/*
	Before running the script - replace the name of the databases where:
		1. CURRENT_BMS_EIS - the name of the BMS_EIS database (SOURCE);
		3. BMS_EIS - the name of the BMS_EIS database (DESTINATION);
*/



DECLARE @FACILITY_CODE NVARCHAR(20), @SOURCE_FACILITY_UID UNIQUEIDENTIFIER, @DESTINATION_FACILITY_UID UNIQUEIDENTIFIER, @SOURCE_VISTA_UID UNIQUEIDENTIFIER,
		@DESTINATION_VISTA_UID UNIQUEIDENTIFIER, @SOURCE_FACILITY_PK INT, @DESTINATION_FACILITY_PK INT,
		@SOURCE_VISTA_PK INT, @DESTINATION_VISTA_PK INT, @VISTA_CODE NVARCHAR(50),
		@SOURCE_FOUND_ENTRIES INT, @DESTINATION_FOUND_ENTRIES INT, 
		@SOURCE_FOUND_UIDS INT, @DESTINATION_FOUND_UIDS INT,
		@SOURCE_FOUND_TRAITS INT, @DESTINATION_FOUND_TRAITS INT,
		@SOURCE_FOUND_TELECOMS INT, @DESTINATION_FOUND_TELECOMS INT,
		@SOURCE_FOUND_ADDRESS INT, @DESTINATION_FOUND_ADDRESS INT,
		@SOURCE_FOUND_PLAYER INT, @DESTINATION_FOUND_PLAYER INT,
		@SOURCE_FOUND_SCOPER INT, @DESTINATION_FOUND_SCOPER INT
SET @FACILITY_CODE = 'BRK'

SELECT @SOURCE_FACILITY_PK = E.PK_ENTITY, @SOURCE_FACILITY_UID = E.IDENTIFIER, 
	   @SOURCE_VISTA_PK = VSE.PK_ENTITY, @SOURCE_VISTA_UID = VSE.IDENTIFIER
FROM CURRENT_BMS_EIS.dbo.ENTITY AS E 
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

SELECT @DESTINATION_FACILITY_PK = E.PK_ENTITY, @DESTINATION_FACILITY_UID = E.IDENTIFIER, 
	   @DESTINATION_VISTA_PK = VSE.PK_ENTITY, @DESTINATION_VISTA_UID = VSE.IDENTIFIER, @VISTA_CODE = V.IDENTIFIER_EXTENSION
FROM BMS_EIS.dbo.ENTITY AS E 
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.ENTITY AS VSE ON V.FK_ENTITY = VSE.PK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

IF @SOURCE_FACILITY_PK IS NULL OR @SOURCE_FACILITY_UID IS NULL OR @SOURCE_VISTA_PK IS NULL OR @SOURCE_VISTA_UID IS NULL
	BEGIN
		SELECT 'FACILITY NOT FOUND'
		RETURN
	END

IF @DESTINATION_FACILITY_PK IS NULL OR @DESTINATION_FACILITY_UID IS NULL OR @DESTINATION_VISTA_PK IS NULL OR @DESTINATION_VISTA_UID IS NULL
	BEGIN
		SELECT 'FACILITY NOT FOUND'
		RETURN
	END
	
--VERIFY ADDRESS AND TELECOM FACILITY

SELECT @SOURCE_FOUND_TELECOMS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_TELECOM AS ET 
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET ON EET.FK_TELECOM = ET.PK_TELECOM
WHERE EET.FK_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_TELECOMS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_TELECOM AS ET 
INNER JOIN BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET ON EET.FK_TELECOM = ET.PK_TELECOM
WHERE EET.FK_ENTITY = @DESTINATION_FACILITY_PK

SELECT @SOURCE_FOUND_ADDRESS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ENTITY_ADDRESS AS EEA  
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ADDRESS AS EA ON EEA.PK_ENTITY_ADDRESS = EA.PK_ADDRESS
WHERE EEA.FK_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_ADDRESS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ENTITY_ADDRESS AS EEA  
INNER JOIN BMS_EIS.dbo.EHL7_ADDRESS AS EA ON EEA.PK_ENTITY_ADDRESS = EA.PK_ADDRESS
WHERE EEA.FK_ENTITY = @DESTINATION_FACILITY_PK

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE 
WHERE FK_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE 
WHERE FK_ENTITY = @DESTINATION_FACILITY_PK


IF @SOURCE_FOUND_ADDRESS = @DESTINATION_FOUND_ADDRESS
	AND @SOURCE_FOUND_TELECOMS = @DESTINATION_FOUND_TELECOMS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	BEGIN
		SELECT 'FACILITY SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'FACILITY UNSUCCESSFULLY IMPORTED'
    
	    SELECT 'IN SOURCE DATABASE - EHL7_TELECOM TABLE ARE: ' + CAST(@SOURCE_FOUND_TELECOMS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_TELECOM TABLE ARE: ' + CAST(@DESTINATION_FOUND_TELECOMS AS NVARCHAR(MAX)) + ' ENTRIES.'
	    
	    SELECT 'IN SOURCE DATABASE - EHL7_ADDRESS TABLE ARE: ' + CAST(@SOURCE_FOUND_ADDRESS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ADDRESS TABLE ARE: ' + CAST(@DESTINATION_FOUND_ADDRESS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ADDRESS = NULL
SET @SOURCE_FOUND_TELECOMS = NULL
SET @SOURCE_FOUND_TRAITS = NULL

SET @DESTINATION_FOUND_ADDRESS = NULL
SET @DESTINATION_FOUND_TELECOMS = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
	
--VERIFY HOS. LOCATION
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = T.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = T.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = U.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = U.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_TELECOMS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_TELECOM AS ET 
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET ON EET.FK_TELECOM = ET.PK_TELECOM
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = EET.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_TELECOMS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_TELECOM AS ET 
INNER JOIN BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET ON EET.FK_TELECOM = ET.PK_TELECOM
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = EET.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'HLOC' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_TELECOMS = @DESTINATION_FOUND_TELECOMS 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	BEGIN
		SELECT 'HOSPITAL LOCATION SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'HOSPITAL LOCATION UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_ORGANIZATION TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ORGANIZATION TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'
	    
	    SELECT 'IN SOURCE DATABASE - EHL7_TELECOM TABLE ARE: ' + CAST(@SOURCE_FOUND_TELECOMS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_TELECOM TABLE ARE: ' + CAST(@DESTINATION_FOUND_TELECOMS AS NVARCHAR(MAX)) + ' ENTRIES.'
	    
	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_TELECOMS = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_TELECOMS = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL

--VERIFY DIVISION
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @DESTINATION_FACILITY_PK

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = T.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = T.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @DESTINATION_FACILITY_PK

SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = U.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = U.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @DESTINATION_FACILITY_PK

SELECT @SOURCE_FOUND_SCOPER = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ROLE AS SCOPER 
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = SCOPER.FK_SCOPER_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @SOURCE_FACILITY_PK

SELECT @DESTINATION_FOUND_SCOPER = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ROLE AS SCOPER 
INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = SCOPER.FK_SCOPER_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
WHERE O.CODE_CODE = 'WGR' AND R.FK_SCOPER_ENTITY = @DESTINATION_FACILITY_PK

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	AND @SOURCE_FOUND_SCOPER = @DESTINATION_FOUND_SCOPER
	BEGIN
		SELECT 'DIVISION SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'DIVISION UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_ORGANIZATION TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ORGANIZATION TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'

	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - EHL7_ROLE TABLE (SCOPER) ARE: ' + CAST(@SOURCE_FOUND_SCOPER AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ROLE TABLE (SCOPER) ARE: ' + CAST(@DESTINATION_FOUND_SCOPER AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_SCOPER = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_SCOPER = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL

--VERIFY WARD
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P ON P.PFK_PLACE = T.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
INNER JOIN BMS_EIS.dbo.EHL7_PLACE AS P ON P.PFK_PLACE = T.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P ON P.PFK_PLACE = U.FK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
INNER JOIN BMS_EIS.dbo.EHL7_PLACE AS P ON P.PFK_PLACE = U.FK_ENTITY
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK

SELECT @SOURCE_FOUND_PLAYER = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ROLE
WHERE FK_PLAYER_ENTITY IN (
SELECT P.PFK_PLACE
FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK
)

SELECT @DESTINATION_FOUND_PLAYER = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ROLE
WHERE FK_PLAYER_ENTITY IN (
SELECT P.PFK_PLACE
FROM BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK
)

SELECT @SOURCE_FOUND_SCOPER = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ROLE
WHERE FK_SCOPER_ENTITY IN (
SELECT P.PFK_PLACE
FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @SOURCE_VISTA_PK
)

SELECT @DESTINATION_FOUND_SCOPER = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ROLE
WHERE FK_SCOPER_ENTITY IN (
SELECT P.PFK_PLACE
FROM BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'OWN'
WHERE P.CODE_CODE = 'WRD' AND R.FK_SCOPER_ENTITY = @DESTINATION_VISTA_PK)

IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	AND @SOURCE_FOUND_SCOPER = @DESTINATION_FOUND_SCOPER
	AND @SOURCE_FOUND_PLAYER = @DESTINATION_FOUND_PLAYER
	BEGIN
		SELECT 'WARD SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'WARD UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_PLACE TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_PLACE TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'

	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - EHL7_ROLE TABLE (SCOPER) ARE: ' + CAST(@SOURCE_FOUND_SCOPER AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ROLE TABLE (SCOPER) ARE: ' + CAST(@DESTINATION_FOUND_SCOPER AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - EHL7_ROLE TABLE (PLAYER) ARE: ' + CAST(@SOURCE_FOUND_PLAYER AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ROLE TABLE (PLAYER) ARE: ' + CAST(@DESTINATION_FOUND_PLAYER AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_SCOPER = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL
SET @SOURCE_FOUND_PLAYER = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_SCOPER = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL
SET @DESTINATION_FOUND_PLAYER = NULL

--VERIFY BED

SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_PLACE AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PLACE
						FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID)

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PLACE FROM BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID)


SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PLACE
						FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID)

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PLACE FROM BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID)

SELECT @SOURCE_FOUND_PLAYER = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_ROLE
WHERE FK_PLAYER_ENTITY IN (SELECT P.PFK_PLACE
						FROM CURRENT_BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID)

SELECT @DESTINATION_FOUND_PLAYER = COUNT(*)
FROM BMS_EIS.dbo.EHL7_ROLE
WHERE FK_PLAYER_ENTITY IN (SELECT P.PFK_PLACE FROM BMS_EIS.dbo.EHL7_PLACE AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PLACE
						INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE P.CODE_CODE = 'BED' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID)


IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	AND @SOURCE_FOUND_PLAYER = @DESTINATION_FOUND_PLAYER
	BEGIN
		SELECT 'BED SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'BED UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_PLACE TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_PLACE TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'

	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - EHL7_ROLE TABLE (PLAYER) ARE: ' + CAST(@SOURCE_FOUND_PLAYER AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_ROLE TABLE (PLAYER) ARE: ' + CAST(@DESTINATION_FOUND_PLAYER AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL
SET @SOURCE_FOUND_PLAYER = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL
SET @DESTINATION_FOUND_PLAYER = NULL

--VERIFY PATIENT
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT' 

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_PERSON AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
INNER JOIN BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
INNER JOIN BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
INNER JOIN BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT' 

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
						WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT' )

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
						INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
						INNER JOIN BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
						WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT') 


SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
						INNER JOIN CURRENT_BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
						WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT' )

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS SOURCE_ENTITY ON SOURCE_ENTITY.PK_ENTITY = P.PFK_PERSON
						INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN BMS_EIS.dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
						INNER JOIN BMS_EIS.dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
						INNER JOIN BMS_EIS.dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
						WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT') 
						
						
IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	BEGIN
		SELECT 'PATIENT SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'PATIENT UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_PERSON TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_PERSON TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'

	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL

--VERIFY PERSON
SELECT @SOURCE_FOUND_ENTRIES = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID

SELECT @DESTINATION_FOUND_ENTRIES = COUNT(*)
FROM BMS_EIS.dbo.EHL7_PERSON AS P
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID

SELECT @SOURCE_FOUND_TRAITS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID)

SELECT @DESTINATION_FOUND_TRAITS = COUNT(*)
FROM BMS_EIS.dbo.TRAIT_VALUE AS T
WHERE T.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
						INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
						INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID)


SELECT @SOURCE_FOUND_UIDS = COUNT(*)
FROM CURRENT_BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM CURRENT_BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN CURRENT_BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
						INNER JOIN CURRENT_BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @SOURCE_VISTA_UID)

SELECT @DESTINATION_FOUND_UIDS = COUNT(*)
FROM BMS_EIS.dbo.EHL7_UID AS U
WHERE U.FK_ENTITY IN (SELECT P.PFK_PERSON
						FROM BMS_EIS.dbo.EHL7_PERSON AS P
						INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = P.PFK_PERSON
						INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY
						INNER JOIN BMS_EIS.dbo.EHL7_UID AS U ON U.FK_ENTITY = E.PK_ENTITY AND U.IDENTIFIER_ROOT = 'SITE'
						WHERE R.CLASS_CODE = 'PROV' AND U.IDENTIFIER_EXTENSION = @DESTINATION_VISTA_UID)
						
						
IF @SOURCE_FOUND_ENTRIES = @DESTINATION_FOUND_ENTRIES 
	AND @SOURCE_FOUND_UIDS = @DESTINATION_FOUND_UIDS  
	AND @SOURCE_FOUND_TRAITS = @DESTINATION_FOUND_TRAITS
	BEGIN
		SELECT 'PERSON SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'PERSON UNSUCCESSFULLY IMPORTED'
		
		SELECT 'IN SOURCE DATABASE - EHL7_PERSON TABLE ARE: ' + CAST(@SOURCE_FOUND_ENTRIES AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_PERSON TABLE ARE: ' + CAST(@DESTINATION_FOUND_ENTRIES AS NVARCHAR(MAX)) + ' ENTRIES.'

	    SELECT 'IN SOURCE DATABASE - EHL7_UID TABLE ARE: ' + CAST(@SOURCE_FOUND_UIDS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - EHL7_UID TABLE ARE: ' + CAST(@DESTINATION_FOUND_UIDS AS NVARCHAR(MAX)) + ' ENTRIES.'
			   
		SELECT 'IN SOURCE DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@SOURCE_FOUND_TRAITS AS NVARCHAR(MAX)) + 
			   ' ENTRIES AND IN DESTINATION DATABASE - TRAIT_VALUE TABLE ARE: ' + CAST(@DESTINATION_FOUND_TRAITS AS NVARCHAR(MAX)) + ' ENTRIES.'
	END	

SET @SOURCE_FOUND_ENTRIES = NULL
SET @SOURCE_FOUND_TRAITS = NULL
SET @SOURCE_FOUND_UIDS = NULL

SET @DESTINATION_FOUND_ENTRIES = NULL
SET @DESTINATION_FOUND_TRAITS = NULL
SET @DESTINATION_FOUND_UIDS = NULL