DECLARE @VISTA_CODE NVARCHAR(20), @SQL NVARCHAR(MAX)
BEGIN TRY
	BEGIN TRANSACTION;
		CREATE TABLE #SITE_DATA(EIS_FACILITY_ID INT, FACILITY_ID UNIQUEIDENTIFIER, FACILITY_CONFIG_SECTION NVARCHAR(200), VISTA_CONFIG_SECTION NVARCHAR(200), ADTPrefix varchar(25), ADTSuffix varchar(25),
					  WardPrefix VARCHAR(25), WardSuffix VARCHAR(25), SiteAlias1 VARCHAR(10), SiteAlias2 VARCHAR(10), SiteAlias3 VARCHAR(10),
					  EMSMailSender VARCHAR(100), EventMailSender VARCHAR(100), LocalTimeAdjust VARCHAR(5), AutoRemovalWaitingList VARCHAR(5), 
					  IntegratedFacility VARCHAR(10), TimeZone VARCHAR(10), Address1 VARCHAR(100), Address2 VARCHAR(100), City VARCHAR(100),
					  STATE VARCHAR(3), ZIP VARCHAR(15), POCTelephone VARCHAR(75), POCEmail VARCHAR(75), PointOfContact VARCHAR(75))
		;WITH FACILITIES_CTE AS
		(
		SELECT E.PK_ENTITY AS EIS_FACILITY_ID  ,E.IDENTIFIER AS FACILITY_ID, F.IDENTIFIER_EXTENSION AS FACILITY_CODE, VE.IDENTIFIER AS VISTA_ID, 
			  'FacilitySettings ' + CAST(E.IDENTIFIER AS NVARCHAR(50)) AS FACILITY_CONFIG_SECTION, 'VistASettings ' + CAST(VE.IDENTIFIER AS NVARCHAR(50)) AS VISTA_CONFIG_SECTION
		FROM $(varBMS_EIS).dbo.ENTITY AS E 
		    INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS VE ON VE.PK_ENTITY = R.FK_SCOPER_ENTITY
		WHERE V.IDENTIFIER_EXTENSION IN ($(varVISTA_CODES)) AND O.CODE_CODE = 'FAC'
		) 
		
		INSERT INTO #SITE_DATA(EIS_FACILITY_ID, FACILITY_ID, FACILITY_CONFIG_SECTION, VISTA_CONFIG_SECTION, ADTPrefix, ADTSuffix, WardPrefix, WardSuffix, 
					SiteAlias1, SiteAlias2, SiteAlias3, EMSMailSender, EventMailSender, LocalTimeAdjust, AutoRemovalWaitingList, IntegratedFacility,
					TimeZone, Address1, Address2, City, STATE, ZIP, POCEmail, POCTelephone, PointOfContact)
		SELECT F.EIS_FACILITY_ID ,F.FACILITY_ID, F.FACILITY_CONFIG_SECTION, F.VISTA_CONFIG_SECTION, SD.ADTPrefix, SD.ADTSuffix, SD.IntegratedPrefix, SD.IntegratedSuffix,
					SD.SiteID2, SD.SiteID3, SD.SiteID4, SD.EMSEmailSender, SD.EventEmailSender, SD.TimeAdjust, UPPER(LEFT(SD.AutoWaitRemoveYN,1))+LOWER(SUBSTRING(SD.AutoWaitRemoveYN,2,LEN(SD.AutoWaitRemoveYN))),
					UPPER(LEFT(SD.IntegratedYN,1))+LOWER(SUBSTRING(SD.IntegratedYN,2,LEN(SD.IntegratedYN))), SD.TimeZone, SD.Address1, SD.Address2, SD.City,
					SD.State, SD.Zip, SD.POCEmail, SD.POCTelephone, SD.PointOfContact
		FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD 
		INNER JOIN FACILITIES_CTE AS F ON SD.SiteID = F.FACILITY_CODE
		WHERE SD.SiteID IS NOT NULL AND SD.BMSSiteYN = 'YES'

		--UPDATE ADT PREFIX	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.ADTPrefix
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'ADTPrefix' AND SD.ADTPrefix IS NOT NULL AND SD.ADTPrefix <> ''

		--INSERT ADT PREFIX
		SET @SQL =COALESCE(@SQL, '') + 'DECLARE @CONFIG_ID INT '
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''ADTPrefix'', ''' + SD.ADTPrefix + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'ADTPrefix'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.ADTPrefix IS NOT NULL AND SD.ADTPrefix <> ''
		 
		--DELETE ADT PREFIX
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'ADTPrefix' AND (SD.ADTPrefix IS NULL or SD.ADTPrefix = '')
				
		--UPDATE ADT SUFFIX	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.ADTSuffix
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'ADTSuffix' AND SD.ADTSuffix IS NOT NULL AND SD.ADTSuffix <> ''

		--INSERT ADT SUFFIX
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''ADTSuffix'', ''' + SD.ADTSuffix + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'ADTSuffix'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.ADTSuffix IS NOT NULL AND SD.ADTSuffix <> ''
		 
		--DELETE ADT SUFFIX
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'ADTSuffix' AND (SD.ADTSuffix IS NULL OR SD.ADTSuffix = '')
				
		--UPDATE WARD PREFIX	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.WardPrefix
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'WardPrefix' AND SD.WardPrefix IS NOT NULL AND SD.WardPrefix <> ''

		--INSERT WARD PREFIX
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''WardPrefix'', ''' + SD.WardPrefix + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'WardPrefix'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.WardPrefix IS NOT NULL AND SD.WardPrefix <> ''
		 
		--DELETE WARD PREFIX
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'WardPrefix' AND (SD.WardPrefix IS NULL or SD.WardPrefix = '')
		
		--UPDATE WARD SUFFIX	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.WardSuffix
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'WardSuffix' AND SD.WardSuffix IS NOT NULL AND SD.WardSuffix <> ''

		--INSERT WARD SUFFIX
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''WardSuffix'', ''' + SD.WardSuffix + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'WardSuffix'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.WardSuffix IS NOT NULL AND SD.WardSuffix <> ''
		 
		--DELETE WARD SUFFIX
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'WardSuffix' AND (SD.WardSuffix IS NULL OR SD.WardSuffix = '')
				
		--UPDATE SITE ALIAS 1	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.SiteAlias1
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'SiteAlias1' AND SD.SiteAlias1 IS NOT NULL AND SD.SiteAlias1 <> ''

		--INSERT SITE ALIAS 1
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''SiteAlias1'', ''' + SD.SiteAlias1 + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'SiteAlias1'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.SiteAlias1 IS NOT NULL AND SD.SiteAlias1 <> ''
		 
		--DELETE SITE ALIAS 1
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'SiteAlias1' AND (SD.SiteAlias1 IS NULL OR SD.SiteAlias1 = '')
		
		--UPDATE SITE ALIAS 2	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.SiteAlias2
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'SiteAlias2' AND SD.SiteAlias2 IS NOT NULL AND SD.SiteAlias2 <> ''

		--INSERT SITE ALIAS 2
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''SiteAlias2'', ''' + SD.SiteAlias2 + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'SiteAlias2'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.SiteAlias2 IS NOT NULL AND SD.SiteAlias2 <> ''
		 
		--DELETE SITE ALIAS 2
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'SiteAlias2' AND (SD.SiteAlias2 IS NULL OR SD.SiteAlias2 = '')
			
		--UPDATE SITE ALIAS 3	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.SiteAlias3
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'SiteAlias3' AND SD.SiteAlias3 IS NOT NULL AND SD.SiteAlias3 <> ''

		--INSERT SITE ALIAS 3
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''SiteAlias3'', ''' + SD.SiteAlias3 + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'SiteAlias3'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.SiteAlias3 IS NOT NULL AND SD.SiteAlias3 <> ''
		 
		--DELETE SITE ALIAS 3
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'SiteAlias3' AND (SD.SiteAlias3 IS NULL OR SD.SiteAlias3 = '')
		
		--UPDATE EMSMailSender	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.EMSMailSender
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'EMSMailSender' AND SD.EMSMailSender IS NOT NULL AND SD.EMSMailSender <> ''

		--INSERT EMSMailSender
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''EMSMailSender'', ''' + SD.EMSMailSender + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'EMSMailSender'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.EMSMailSender IS NOT NULL AND SD.EMSMailSender <> ''
		 
		--DELETE EMSMailSender
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'EMSMailSender' AND (SD.EMSMailSender IS NULL OR SD.EMSMailSender = '')
		
		--UPDATE EventMailSender	
		UPDATE BMS_CONFIG
			SET CONFIG_VALUE = SD.EventMailSender
		FROM $(varBMS).dbo.CONFIG AS BMS_CONFIG
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE BMS_CONFIG.CONFIG_KEY = 'EventMailSender' AND SD.EventMailSender IS NOT NULL AND SD.EventMailSender <> ''

		--INSERT EventMailSender
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''EventMailSender'', ''' + SD.EventMailSender + ''', ''APP'', ''ST'', '''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'EventMailSender'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.EventMailSender IS NOT NULL AND SD.EventMailSender <> ''
		 
		--DELETE EventMailSender
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'EventMailSender' AND (SD.EventMailSender IS NULL OR SD.EventMailSender = '')
		
		--VISTA LOCAL TIME ADJUST
		CREATE TABLE #VISTA_SITE_DATA(VISTA_CONFIG_SECTION NVARCHAR(200), NewVistALocalTimeAdjust VARCHAR(5), NewVistASiteTimeZone VARCHAR(10))
		
		INSERT INTO #VISTA_SITE_DATA(VISTA_CONFIG_SECTION)
		SELECT VISTA_CONFIG_SECTION 
		FROM #SITE_DATA
		GROUP BY VISTA_CONFIG_SECTION
		
		;WITH CTE_NEW_VISTA_LOCAL_TIME_ADJUST(VISTA_CONFIG_SECTION, NEW_VISTA_LOCAL_TIME_ADJUST, DuplicateCount) AS
		(
				SELECT
				VISTA_CONFIG_SECTION,
				LocalTimeAdjust,
				ROW_NUMBER() OVER(PARTITION BY VISTA_CONFIG_SECTION ORDER BY VISTA_CONFIG_SECTION) AS DuplicateCount
				FROM #SITE_DATA WHERE LocalTimeAdjust IS NOT NULL AND LocalTimeAdjust <> ''
		)
		
		--UPDATE NewVistALocalTimeAdjust
		UPDATE VISTA_SITE_DATE
			SET NewVistALocalTimeAdjust = CTE.NEW_VISTA_LOCAL_TIME_ADJUST
		FROM #VISTA_SITE_DATA AS VISTA_SITE_DATE
		INNER JOIN CTE_NEW_VISTA_LOCAL_TIME_ADJUST AS CTE ON CTE.VISTA_CONFIG_SECTION = VISTA_SITE_DATE.VISTA_CONFIG_SECTION
		WHERE CTE.DuplicateCount = 1
		
		--DELETE VISTA LOCAL TIME ADJUST
		DELETE C FROM $(varBMS).dbo.CONFIG AS C 
		INNER JOIN #VISTA_SITE_DATA AS NEW_C ON C.SECTION = NEW_C.VISTA_CONFIG_SECTION
		WHERE C.CONFIG_KEY = 'VistALocalTimeAdjust'
		
		--INSERT VISTA LOCAL TIME ADJUST		
		INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)	
		SELECT 'InfoWorld', '', V_SD.VISTA_CONFIG_SECTION, 'VistALocalTimeAdjust', V_SD.NewVistALocalTimeAdjust, 'APP', 'INT', ''
		FROM #VISTA_SITE_DATA AS V_SD 
		WHERE V_SD.NewVistALocalTimeAdjust IS NOT NULL
		
		--DELETE LOCAL TIME ADJUST
		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = C.SECTION  
		WHERE  C.CONFIG_KEY = 'LocalTimeAdjust' 
		
		--INSERT LOCAL TIME ADJUST
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''LocalTimeAdjust'', ''' + SD.LocalTimeAdjust + ''', ''APP'', ''INT'', '''')'
		FROM #SITE_DATA AS SD 
		WHERE SD.LocalTimeAdjust IS NOT NULL AND SD.LocalTimeAdjust <> ''
		 
		--UPDATE AUTO REMOVAL WAITING LIST
		UPDATE BMS_CONFIG_EVS
			SET CODE = SD.AutoRemovalWaitingList,
				DISPLAY_NAME = SD.AutoRemovalWaitingList
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'AutoRemovalWaitingList'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE SD.AutoRemovalWaitingList IS NOT NULL AND SD.AutoRemovalWaitingList <> '' AND BMS_CONFIG_EVS.CODE <> SD.AutoRemovalWaitingList
		
		--INSERT AUTO REMOVAL WAITING LIST
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES ( ''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''AutoRemovalWaitingList'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + SD.AutoRemovalWaitingList + ''', ''2.12.24.15'', ''StrictDecision'', ''' + SD.AutoRemovalWaitingList + ''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'AutoRemovalWaitingList'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.AutoRemovalWaitingList IS NOT NULL AND SD.AutoRemovalWaitingList <> ''
		
		--DELETE AUTO REMOVAL WAITING LIST
		SELECT @SQL = @SQL + ' 
				DELETE CEVS FROM $(varBMS).dbo.CONFIG_EVS AS CEVS WHERE CEVS.ID = ''' + CAST(BMS_CONFIG_EVS.ID AS NVARCHAR(50)) + '''
				DELETE C FROM $(varBMS).dbo.CONFIG AS C WHERE C.ID = '''+ CAST(BMS_CONFIG_EVS.CONFIG_ID AS NVARCHAR(50)) + '''
		'
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'AutoRemovalWaitingList'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE SD.AutoRemovalWaitingList IS NULL OR SD.AutoRemovalWaitingList = '' 
		
		--UPDATE INTEGRATED FACILITY
		UPDATE BMS_CONFIG_EVS
			SET CODE = SD.IntegratedFacility,
				DISPLAY_NAME = SD.IntegratedFacility
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'IntegratedFacility'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE SD.IntegratedFacility IS NOT NULL AND SD.IntegratedFacility <> '' AND BMS_CONFIG_EVS.CODE <> SD.IntegratedFacility
		
		--INSERT INTEGRATED FACILITY
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES ( ''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''IntegratedFacility'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + SD.IntegratedFacility + ''', ''2.12.24.15'', ''StrictDecision'', ''' + SD.IntegratedFacility + ''')'
		FROM #SITE_DATA AS SD 
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'IntegratedFacility'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.IntegratedFacility IS NOT NULL AND SD.IntegratedFacility <> ''
		
		--DELETE INTEGRATED FACILITY
		SELECT @SQL = @SQL + ' 
				DELETE CEVS FROM $(varBMS).dbo.CONFIG_EVS AS CEVS WHERE CEVS.ID = '''+ CAST(BMS_CONFIG_EVS.ID AS NVARCHAR(50)) + '''
				DELETE C FROM $(varBMS).dbo.CONFIG AS C WHERE C.ID = '''+ CAST(BMS_CONFIG_EVS.CONFIG_ID AS NVARCHAR(50)) + '''
		'
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'IntegratedFacility'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE SD.IntegratedFacility IS NULL OR SD.IntegratedFacility = '' 
		
		--VISTA TIME ZONE
		;WITH CTE_NEW_VISTA_TIME_ZONE(VISTA_CONFIG_SECTION, NEW_VISTA_TIME_ZONE, DuplicateCount) AS
		(
				SELECT
				VISTA_CONFIG_SECTION,
				TimeZone,
				ROW_NUMBER() OVER(PARTITION BY VISTA_CONFIG_SECTION ORDER BY VISTA_CONFIG_SECTION) AS DuplicateCount
				FROM #SITE_DATA WHERE TimeZone IS NOT NULL AND TimeZone <> ''
		)
		
		--UPDATE NewVistASiteTimeZone
		UPDATE VISTA_SITE_DATE
			SET NewVistASiteTimeZone = CTE.NEW_VISTA_TIME_ZONE
		FROM #VISTA_SITE_DATA AS VISTA_SITE_DATE
		INNER JOIN CTE_NEW_VISTA_TIME_ZONE AS CTE ON CTE.VISTA_CONFIG_SECTION = VISTA_SITE_DATE.VISTA_CONFIG_SECTION
		WHERE CTE.DuplicateCount = 1
		
		--DELETE VISTA TIME ZONE
		DELETE EVS FROM $(varBMS).dbo.CONFIG_EVS AS EVS 
		INNER JOIN $(varBMS).dbo.CONFIG AS C ON EVS.CONFIG_ID = C.ID
		INNER JOIN #VISTA_SITE_DATA AS VISTA_SITE_DATE ON C.SECTION = VISTA_SITE_DATE.VISTA_CONFIG_SECTION
		WHERE C.CONFIG_KEY = 'VistASiteTimeZone'
		
		DELETE C FROM $(varBMS).dbo.CONFIG AS C 
		INNER JOIN #VISTA_SITE_DATA AS VISTA_SITE_DATE ON C.SECTION = VISTA_SITE_DATE.VISTA_CONFIG_SECTION
		WHERE C.CONFIG_KEY = 'VistASiteTimeZone'
		
		--INSERT VISTA TIME ZONE
		SELECT @SQL = @SQL + ' 
		INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		VALUES (''InfoWorld'', '''', ''' + SD.VISTA_CONFIG_SECTION + ''', ''VistASiteTimeZone'', NULL, ''APP'', ''EVS'', '''')
		SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
		INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
		VALUES (@CONFIG_ID, ''' + SD.NewVistASiteTimeZone + ''', ''2.12.24.6'', ''TimeZone'', ''' + CP.propertyValue + ''')'
		FROM #VISTA_SITE_DATA AS SD 
		INNER JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON SD.NewVistASiteTimeZone = CP.conceptCode AND CP.codingSchemeName = 'TimeZone' AND CP.property = 'textualPresentation'
		WHERE SD.NewVistASiteTimeZone IS NOT NULL AND SD.NewVistASiteTimeZone <> ''
		
		--UPDATE TIME ZONE 
		UPDATE BMS_CONFIG_EVS
			SET CODE = SD.TimeZone,
				DISPLAY_NAME = CP.propertyValue
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'FacilitySiteTimeZone'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		INNER JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON SD.TimeZone = CP.conceptCode AND CP.codingSchemeName = 'TimeZone' AND CP.property = 'textualPresentation'
		WHERE SD.TimeZone IS NOT NULL AND SD.TimeZone <> '' AND BMS_CONFIG_EVS.CODE <> SD.TimeZone
		
		--INSERT TIME ZONE 
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES ( ''InfoWorld'', '''', ''' + SD.FACILITY_CONFIG_SECTION + ''', ''FacilitySiteTimeZone'', NULL, ''APP'', ''EVS'', '''')
			SET @CONFIG_ID = IDENT_CURRENT(''$(varBMS).dbo.CONFIG'')
			INSERT INTO $(varBMS).dbo.CONFIG_EVS (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)	
			VALUES (@CONFIG_ID, ''' + SD.TimeZone + ''', ''2.12.24.6'', ''TimeZone'', ''' + CP.propertyValue + ''')'
		FROM #SITE_DATA AS SD 
		INNER JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON SD.TimeZone = CP.conceptCode AND CP.codingSchemeName = 'TimeZone' AND CP.property = 'textualPresentation'
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.SECTION = SD.FACILITY_CONFIG_SECTION AND BMS_CONFIG.CONFIG_KEY = 'FacilitySiteTimeZone'
		WHERE BMS_CONFIG.SECTION IS NULL AND SD.TimeZone IS NOT NULL AND SD.TimeZone <> ''
		
		--DELETE TIME ZONE 
		SELECT @SQL = @SQL + ' 
				DELETE CEVS FROM $(varBMS).dbo.CONFIG_EVS AS CEVS WHERE CEVS.ID = '''+ CAST(BMS_CONFIG_EVS.ID AS NVARCHAR(50)) + '''
				DELETE C FROM $(varBMS).dbo.CONFIG AS C WHERE C.ID = '''+ CAST(BMS_CONFIG_EVS.CONFIG_ID AS NVARCHAR(50)) + '''
		'
		FROM $(varBMS).dbo.CONFIG_EVS AS BMS_CONFIG_EVS
		INNER JOIN $(varBMS).dbo.CONFIG AS BMS_CONFIG ON BMS_CONFIG.ID = BMS_CONFIG_EVS.CONFIG_ID AND BMS_CONFIG.CONFIG_KEY = 'FacilitySiteTimeZone'
		INNER JOIN #SITE_DATA AS SD ON SD.FACILITY_CONFIG_SECTION = BMS_CONFIG.SECTION
		WHERE SD.TimeZone IS NULL OR SD.TimeZone = '' 
				
		-- CONFIG: INSERT SISTER SITES	
		DELETE FROM $(varBMS).dbo.CONFIG WHERE CONFIG_KEY ='IntegratedSiteSisterConfigKey' OR SECTION = 'Sister Sites' 
		
		CREATE TABLE #sisterSitesTable (NR INT, CODES NVARCHAR(100), UIDS NVARCHAR(MAX))
		INSERT INTO #sisterSitesTable (NR, CODES)
		SELECT DISTINCT DENSE_RANK()  OVER (ORDER BY SharedSiteList), SharedSiteList FROM $(varBMS_NATIONAL_FACILITY).dbo.BMS_SharedSites_Data WHERE SharedSiteList IS NOT NULL AND LEN(SharedSiteList) > 0
		DECLARE @SS_COUNT INT, @I INT, @SISTER_CODES NVARCHAR(100), @SISTER_UIDS NVARCHAR(MAX)
		SELECT @SS_COUNT = MAX(NR) FROM #sisterSitesTable
		SET @I = 1
		WHILE @I <= @SS_COUNT
		BEGIN
			SELECT @SISTER_CODES = CODES FROM #sisterSitesTable WHERE NR = @I
			SET @SISTER_UIDS = ''
			SELECT @SISTER_UIDS = @SISTER_UIDS + CAST(E.IDENTIFIER AS NVARCHAR(50)) + ', '
				FROM $(varBMS).dbo.AUTHZ_GET_STRTOKENS(@SISTER_CODES,',') AS SPL 
					INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS U ON U.IDENTIFIER_EXTENSION = SPL.TOK AND U.IDENTIFIER_ROOT = 'CODE'
					INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON U.FK_ENTITY = O.PFK_ORGANIZATION AND O.CODE_CODE = 'FAC'
					INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
			UPDATE #sisterSitesTable 
				SET UIDS = LEFT(@SISTER_UIDS, LEN(@SISTER_UIDS)-1) WHERE NR = @I
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES ('InfoWorld', '', 'Sister Sites', CAST(@I AS NVARCHAR(5)), LEFT(@SISTER_UIDS, LEN(@SISTER_UIDS)-1), 'APP', 'ST', 'Sister Sites Group' + CAST(@I AS NVARCHAR(5)))
			SET @I = @I + 1
		END

		-- FACILITY SISTER SITES
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''FacilitySettings ' + CAST(E.IDENTIFIER AS NVARCHAR(50)) + ''', ''IntegratedSiteSisterConfigKey'', ' + 
			(SELECT TOP 1 CONFIG_KEY FROM $(varBMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(E.IDENTIFIER AS NVARCHAR(50))+'%') + ', ''APP'', ''INT'', '''')'
		FROM $(varBMS_EIS).dbo.ENTITY AS E
		INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON F.FK_ENTITY = E.PK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_Site_Data] AS SD  ON SD.SiteID = F.IDENTIFIER_EXTENSION
		WHERE SD.IntegratedSiteList IS NOT NULL AND LEN(SD.IntegratedSiteList) > 0
		 AND (SELECT COUNT(CONFIG_KEY) FROM $(varBMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(E.IDENTIFIER AS NVARCHAR(50))+'%') > 0
		
		EXECUTE sp_executesql @SQL
		
		DROP TABLE #sisterSitesTable
		
		--DELETE FROM HISTORY
		DELETE FROM $(varBMS_HISTORY).dbo.CONFIG_H WHERE ID NOT IN (SELECT ID FROM $(varBMS).dbo.CONFIG WHERE CONFIG_KEY ='IntegratedSiteSisterConfigKey' OR SECTION = 'Sister Sites') 
		AND (CONFIG_KEY ='IntegratedSiteSisterConfigKey' OR SECTION = 'Sister Sites')
		
		CREATE TABLE #CONFIG(ID INT)
		INSERT INTO #CONFIG(ID)
		SELECT HIS.ID FROM $(varBMS_HISTORY).dbo.CONFIG_H AS HIS
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS C ON C.ID = HIS.ID
		WHERE C.ID IS NULL AND HIS.SECTION IN (SELECT FACILITY_CONFIG_SECTION FROM #SITE_DATA)
		UNION 
		SELECT HIS.ID FROM $(varBMS_HISTORY).dbo.CONFIG_H AS HIS
		LEFT OUTER JOIN $(varBMS).dbo.CONFIG AS C ON C.ID = HIS.ID
		WHERE C.ID IS NULL AND HIS.SECTION IN (SELECT VISTA_CONFIG_SECTION FROM #VISTA_SITE_DATA)
		
		DELETE HIS FROM $(varBMS_HISTORY).dbo.CONFIG_EVS_H AS HIS
		INNER JOIN #CONFIG AS C ON C.ID = HIS.CONFIG_ID
		
		DELETE HIS FROM $(varBMS_HISTORY).dbo.CONFIG_H AS HIS
		INNER JOIN #CONFIG AS C ON C.ID = HIS.ID

		DROP TABLE #CONFIG
		DROP TABLE #VISTA_SITE_DATA
		
		-- EIS: UPDATE FACILITY ADDRESS
		SET @SQL = ''
		SELECT @SQL = @SQL + ' 
			EXEC $(varBMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(SD.EIS_FACILITY_ID AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(SD.Address1, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=N''' + ISNULL(UPPER(SD.City), '') + ''',@COUNTY=N''' + ISNULL(UPPER(SD.State), '') + ''',@COUNTRY=N''' + ISNULL(UPPER(SD.State), '') + ''',@POSTAL_CODE=N''' + ISNULL(SD.Zip, '') + ''',@USE=N''32''
			EXEC $(varBMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(SD.EIS_FACILITY_ID AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(SD.Address2, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=NULL,@COUNTY=NULL,@COUNTRY=NULL,@POSTAL_CODE=NULL,@USE=N''8''
			EXEC $(varBMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(SD.EIS_FACILITY_ID AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''mailto:' + ISNULL(SD.POCEmail, '') + ''',@USE=32,@CONTACT=N''CONTACT2''
			EXEC $(varBMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(SD.EIS_FACILITY_ID AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''tel:' + ISNULL(SD.POCTelephone, '') + ''',@USE=32,@CONTACT=N''CONTACT3''
			EXEC $(varBMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(SD.FACILITY_ID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''POINT_OF_CONTACT'',@TRAIT_VALUE_STRING=N''' + ISNULL(SD.PointOfContact, '') + ''',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL'
		FROM #SITE_DATA AS SD
		EXECUTE sp_executesql @SQL
		
		DROP TABLE #SITE_DATA
		
	SELECT 'CONFIGURATION - successfully updated'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
