DECLARE @SQL NVARCHAR(MAX), @CD_CODE NVARCHAR(20), @EIS_FACILITY_ID INT, @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER, @VISTA_UID UNIQUEIDENTIFIER,  
		@TIME_ZONE_MINUTES_OFFSET INT, @START_DATE DATETIME, @DAYLIGHT_SAVING_TIME INT, 
		@START_DATE_1 DATETIME, @END_DATE_1 DATETIME, @START_DATE_2 DATETIME, @END_DATE_2 DATETIME, @START_DATE_3 DATETIME, @END_DATE_3 DATETIME

CREATE TABLE #BEDS (NAME NVARCHAR(50), ID UNIQUEIDENTIFIER, PK INT)
CREATE TABLE #STRICT_DECISION(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #WAITING_AREA(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #FEE_REASON(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #VISTA_SPECIALTY(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #FEE_DISPOSITION(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #PATIENTS(PATIENT_UID UNIQUEIDENTIFIER, PATIENT_SSN NVARCHAR(15))

SET @FACILITY_CODE = '$(varFacilityCode)'
SET @TIME_ZONE_MINUTES_OFFSET = $(varTimeZoneMinutesOffSet)
SET @START_DATE = '$(varStartDate)'
SET @DAYLIGHT_SAVING_TIME = @TIME_ZONE_MINUTES_OFFSET - 60
SET @START_DATE_1 = '2011-03-13 02:00:00'
SET @END_DATE_1 = '2011-11-06 02:00:00'
SET @START_DATE_2 = '2012-03-11 02:00:00'
SET @END_DATE_2 = '2012-11-04 02:00:00'
SET @START_DATE_3 = '2013-03-10 02:00:00'
SET @END_DATE_3 = '2013-11-03 02:00:00'
SELECT @EIS_FACILITY_ID= E.PK_ENTITY, 
		@CD_CODE = V.IDENTIFIER_EXTENSION, 
		@FACILITY_UID = E.IDENTIFIER, 
		@VISTA_UID = E_VISTA.IDENTIFIER
FROM $(varBMS_EIS).dbo.ENTITY AS E 
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION  
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E_VISTA ON E_VISTA.PK_ENTITY = V.FK_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'
SET @CD_CODE = @CD_CODE + '_' + @FACILITY_CODE + '_'

INSERT INTO #beds(NAME, ID, PK)
SELECT DISTINCT  BED.NAME, E.IDENTIFIER, BED.PFK_PLACE
FROM $(varBMS_EIS).[dbo].[EHL7_PLACE] AS BED
INNER JOIN $(varBMS_EIS).[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
WHERE BED.CODE_DISPLAY_NAME ='BED' 
AND R_BED.FK_SCOPER_ENTITY IN (SELECT O.PFK_ORGANIZATION
							   FROM $(varBMS_EIS).[dbo].[EHL7_ORGANIZATION] AS O
							   INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
							   WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID)

;WITH DUPLICATE_BEDS (PK, NAME)
AS
(
SELECT MAX(PK), NAME
FROM #BEDS
GROUP BY NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL							   

INSERT INTO #PATIENTS(PATIENT_UID, PATIENT_SSN)
SELECT E.IDENTIFIER, EHL7_UID1.IDENTIFIER_EXTENSION
FROM $(varBMS_EIS).dbo.ENTITY AS E
INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS EHL7_UID1 ON EHL7_UID1.FK_ENTITY= E.PK_ENTITY AND EHL7_UID1.IDENTIFIER_ROOT ='SSN'  
WHERE EHL7_UID1.IDENTIFIER_EXTENSION IN
(SELECT LEFT(LTRIM(RTRIM(WAITING_LIST.SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(WAITING_LIST.SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(WAITING_LIST.SSN)),4)
FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Waiting] AS WAITING_LIST 
WHERE WAITING_LIST.REMOVE_FROM_LIST IS NOT NULL AND WAITING_LIST.EVENT_TIME >= @START_DATE AND CAST(WAITING_LIST.REMOVE_FROM_LIST as DATETIME) >= @START_DATE )

INSERT INTO #STRICT_DECISION(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
	WHERE codingSchemeName = 'StrictDecision'
	
INSERT INTO #WAITING_AREA(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'WaitingArea' and conceptCode like '%'+ @CD_CODE + '%'

INSERT INTO #FEE_REASON(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'FeeReason'

INSERT INTO #VISTA_SPECIALTY(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'VistaSpecialty'

INSERT INTO #FEE_DISPOSITION(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'FeeDisposition'

CREATE TABLE #WAITING(ROW_NO BIGINT, ID INT, INSERT_WAITING_LIST NVARCHAR(MAX))

;WITH W_L AS
(
	Select 	ROW_NUMBER() Over (Order By WL.ID) As ROW_NO,
	WL.ID,
	'SET @ACT_ID =-1
	SELECT @FLOW_ID = NEWID()	
	exec $(varBMS).dbo.usp_Insert_WaitingListItem
	@ACT_ID	= @ACT_ID OUTPUT,
	@CREATION_DATE = ' + CASE WHEN (WL.EVENT_TIME BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.EVENT_TIME BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.EVENT_TIME BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.EVENT_TIME), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.EVENT_TIME), 120), 19) + '''' END + ',
	@CANCELED_DATE = NULL,
	@PARENT_ACT_ID = NULL,
	@FLOW_ID= @FLOW_ID,
	@DOMAIN_ID=''InfoWorld'',
	@PATIENT_UID = ''' + CONVERT(NVARCHAR(50), PATIENT.PATIENT_UID) +''',
	@IEN = NULL,
	@FACILITY_UID = ''' + CONVERT(NVARCHAR(50), @FACILITY_UID) +''',
	@PROBLEM = ' + CASE WHEN WL.CURRENT_WARD IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.CURRENT_WARD,'''','''''') + '''' END + ',
	@FEE_COMMENTS = ' + CASE WHEN WL.FEE_COMMENTS IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.FEE_COMMENTS,'''','''''') + '''' END + ',
	@REMOVED_DATE = ' + CASE WHEN (WL.REMOVE_FROM_LIST BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.REMOVE_FROM_LIST BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.REMOVE_FROM_LIST BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.REMOVE_FROM_LIST), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.REMOVE_FROM_LIST), 120), 19) + '''' END + ',
	@WAITING_AREA_CODE =' + CASE WHEN WAIT_AREA.CODE IS NULL THEN 'NULL' ELSE '''' + REPLACE(WAIT_AREA.CODE,'''','''''') + '''' END +',
	@WAITING_AREA_CODE_SYSTEM = ' + CASE WHEN WAIT_AREA.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.8''' END +',
	@WAITING_AREA_CODE_SYSTEM_NAME =''WaitingArea'',
	@WAITING_AREA_DISPLAY_NAME = ' + CASE WHEN WAIT_AREA.CODE IS NULL THEN 'NULL' ELSE '''' + REPLACE(WAIT_AREA.DISPLAY_NAME,'''','''''') + '''' END +', 
	@REASON_USING_FEE_CODE = ' + CASE WHEN FEE_REASON.CODE IS NULL THEN 'NULL' ELSE '''' + FEE_REASON.CODE + '''' END +', 
	@REASON_USING_FEE_CODE_SYSTEM = ' + CASE WHEN FEE_REASON.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.25''' END +',
	@REASON_USING_FEE_CODE_SYSTEM_NAME = ''FeeReason'',
	@REASON_USING_FEE_DISPLAY_NAME = ' + CASE WHEN FEE_REASON.CODE IS NULL THEN 'NULL' ELSE '''' + FEE_REASON.DISPLAY_NAME + '''' END +', 
	@SERVICE_RECEIVING_FEE_CODE	= ' + CASE WHEN VISTA_SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''' + VISTA_SPECIALTY.CODE + '''' END +', 
	@SERVICE_RECEIVING_FEE_CODE_SYSTEM = ' + CASE WHEN VISTA_SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.39''' END +',
	@SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME	= ''VistaSpecialty'',
	@SERVICE_RECEIVING_FEE_DISPLAY_NAME	= ' + CASE WHEN VISTA_SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''' + VISTA_SPECIALTY.DISPLAY_NAME + '''' END +', 
	@AUTHORIZED_FEE_CODE = ' + CASE WHEN AUTHORIZED_FEE.CODE IS NULL THEN 'NULL' ELSE '''' + AUTHORIZED_FEE.CODE + '''' END +', 
	@AUTHORIZED_FEE_CODE_SYSTEM	= ' + CASE WHEN AUTHORIZED_FEE.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.15''' END +',
	@AUTHORIZED_FEE_CODE_SYSTEM_NAME = ''StrictDecision'',
	@AUTHORIZED_FEE_DISPLAY_NAME = ' + CASE WHEN AUTHORIZED_FEE.CODE IS NULL THEN 'NULL' ELSE '''' + AUTHORIZED_FEE.DISPLAY_NAME + '''' END +', 
	@CONTRACT_FEE_CODE = ' + CASE WHEN CONTRACTED.CODE IS NULL THEN 'NULL' ELSE '''' + CONTRACTED.CODE + '''' END +', 
	@CONTRACT_FEE_CODE_SYSTEM = ' + CASE WHEN CONTRACTED.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.15''' END +',
	@CONTRACT_FEE_CODE_SYSTEM_NAME = ''StrictDecision'',
	@CONTRACT_FEE_DISPLAY_NAME = ' + CASE WHEN CONTRACTED.CODE IS NULL THEN 'NULL' ELSE '''' + CONTRACTED.DISPLAY_NAME + '''' END +', 	
	@FEE_DISPOSITION_CODE = ' + CASE WHEN FEE_DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''' + FEE_DISPOSITION.CODE + '''' END +', 
	@FEE_DISPOSITION_CODE_SYSTEM = ' + CASE WHEN FEE_DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.23''' END +',
	@FEE_DISPOSITION_CODE_SYSTEM_NAME = ''FeeDisposition'',
	@FEE_DISPOSITION_DISPLAY_NAME = ' + CASE WHEN FEE_DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''' + FEE_DISPOSITION.DISPLAY_NAME + '''' END +',
	@TYPE_OF_BED_WARD = ' + CASE WHEN FEE_DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''' + FEE_DISPOSITION.DISPLAY_NAME + '''' END +', 
	@REQUESTED_BED_UID = '+ CASE WHEN BED.ID IS NULL THEN 'NULL' ELSE '''' + CONVERT(NVARCHAR(50), BED.ID) + '''' END +',
	@REQUESTED_BED_DATE = ' + CASE WHEN WL.BED_ASSIGNED_DT IS NULL THEN 'NULL'
									  WHEN (WL.BED_ASSIGNED_DT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.BED_ASSIGNED_DT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.BED_ASSIGNED_DT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.BED_ASSIGNED_DT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.BED_ASSIGNED_DT), 120), 19) + '''' END + ',
	@REQUESTED_DATE = ' + CASE WHEN WL.REQUEST_DT IS NULL THEN 'NULL'
									  WHEN (WL.REQUEST_DT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.REQUEST_DT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.REQUEST_DT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.REQUEST_DT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.REQUEST_DT), 120), 19) + '''' END + ',
	@VISTA_SITE_UID =''' + CONVERT(NVARCHAR(50),@VISTA_UID) +''',
	@IS_IN_HOUSE =0,
	@LAST_EDIT_BY =' + CASE WHEN WL.RECORD_LAST_EDITED_BY IS NULL THEN 'NULL' ELSE '''' + WL.RECORD_LAST_EDITED_BY + '''' END + ',
	@IS_BED_IN_ISOLATION=0,
	@WAIT_TIME_ALERT_DATE=NULL,
	@IS_COMMUNITY_LIVING_CENTER =0,
	@IS_EVACUATION_PATIENT =0,
	@EVACUATION_DISPOSITION_STATUS_CODE=NULL,
	@EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM =NULL,
	@EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME =NULL,
	@EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME =NULL,
	@EVACUATION_EXPECTED_DATE =NULL,
	@EVACUATION_ACTUAL_DATE =NULL,
	@EVACUATION_REASON_FOR_DELAY =NULL,
	@EVACUATION_TRANSFER_EVACUATE_TO =NULL,
	@EVACUATION_EQUIP_SUPPLY_REQUIREMENTS =NULL,
	@EVACUATION_TRANSPORTATION_CARE_LEVEL =NULL,
	@EVACUATION_ENROUTE_MEDICAL_ATTENDANT =NULL,
	@EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT =NULL,
	@EVACUATION_TRANSPORTATION_TYPE_CODE =NULL,
	@EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM =NULL,
	@EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME =NULL,
	@EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME =NULL,
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE =NULL,
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM =NULL,
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME =NULL,
	@EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME =NULL,
	@EVACUATION_TRANSPORTATION_COMMENTS =NULL,
	@EVACUATION_DESTINATION_ADDRESS =NULL,
	@EVACUATION_DESTINATION_CITY_STATE =NULL,
	@EVACUATION_DESTINATION_POC_TELEPHONE =NULL,
	@EVACUATION_ORIGINATOR_POC_TELEPHONE=NULL,
	@EVACUATION_COMMENTS =NULL,
	@EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER =NULL,
	@EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER =NULL' AS  INSERT_WAITING_LIST
	FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Waiting] AS WL
	INNER JOIN #PATIENTS AS PATIENT ON PATIENT.PATIENT_SSN = LEFT(LTRIM(RTRIM(WL.SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(WL.SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(WL.SSN)),4) 
	LEFT JOIN #WAITING_AREA AS WAIT_AREA ON WAIT_AREA.DISPLAY_NAME = WL.CURRENT_WAIT_AREA
	LEFT JOIN #FEE_REASON AS FEE_REASON ON FEE_REASON.DISPLAY_NAME = WL.REASON_USING_FEE
	LEFT JOIN #VISTA_SPECIALTY AS VISTA_SPECIALTY ON VISTA_SPECIALTY.DISPLAY_NAME = WL.COMMUNITY_SERVICES
	LEFT JOIN #FEE_DISPOSITION AS FEE_DISPOSITION ON FEE_DISPOSITION.DISPLAY_NAME = WL.ACUTE
	LEFT JOIN #STRICT_DECISION AS AUTHORIZED_FEE ON AUTHORIZED_FEE.DISPLAY_NAME = WL.AUTHORIZED_FEE
	LEFT JOIN #STRICT_DECISION AS CONTRACTED ON CONTRACTED.DISPLAY_NAME = WL.CONTRACTED
	LEFT JOIN #BEDS AS BED ON BED.NAME = WL.ROOM_BED_ASSIGNED
	WHERE WL.REMOVE_FROM_LIST IS NOT NULL AND WL.EVENT_TIME >= @START_DATE AND CAST(WL.REMOVE_FROM_LIST AS DATETIME) >= @START_DATE 
)

INSERT INTO #WAITING(ROW_NO, ID, INSERT_WAITING_LIST)
SELECT ROW_NO, ID, INSERT_WAITING_LIST
FROM W_L
ORDER BY W_L.ID

DROP TABLE #BEDS
DROP TABLE #FEE_DISPOSITION
DROP TABLE #STRICT_DECISION
DROP TABLE #WAITING_AREA
DROP TABLE #VISTA_SPECIALTY
DROP TABLE #FEE_REASON
DROP TABLE #PATIENTS

DECLARE @LAST_INDEX INT, @LAST_INDEX_PAGE INT, @LAST_INDEX_PREV INT, @PAGE_COUNT INT, @I INT
SET @PAGE_COUNT = 500
SET @I = 1
SET @LAST_INDEX_PAGE = 0
SET @LAST_INDEX_PREV = 0
SELECT @LAST_INDEX = MAX(ID) FROM #WAITING
WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
BEGIN
	SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
	SELECT @LAST_INDEX_PAGE = ID FROM #WAITING WHERE ROW_NO = @PAGE_COUNT*@I
	IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
		SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #WAITING
SET @SQL = 'DECLARE @FLOW_ID UNIQUEIDENTIFIER, @ACT_ID INT '
SELECT @SQL = @SQL + '
		'+  WAITING_LIST.INSERT_WAITING_LIST +'
 '
FROM #WAITING  AS WAITING_LIST
WHERE WAITING_LIST.ID > @LAST_INDEX_PREV AND WAITING_LIST.ID <= @LAST_INDEX_PAGE
DELETE FROM #WAITING WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
SET @I = @I + 1
EXEC sp_executesql @SQL
SET @SQL = NULL
END 

DROP TABLE #WAITING
