	
	CREATE TABLE #BED_CLEAN(ID INT)

	INSERT INTO #BED_CLEAN(ID)
	SELECT CLN.ID
	FROM BED_CLEAN AS CLN
	INNER JOIN(
				SELECT MAX(REQUESTED_DATE) AS REQUESTED_DATE, BED_UID
				FROM BED_CLEAN
				WHERE WARD_UID IN ('@WARD_UID_LISTS')
				GROUP BY BED_UID 
			  ) LAST_BED_CLEAN_REQUEST ON LAST_BED_CLEAN_REQUEST.REQUESTED_DATE = CLN.REQUESTED_DATE AND LAST_BED_CLEAN_REQUEST.BED_UID = CLN.BED_UID
    WHERE CLN.WARD_UID IN ('@WARD_UID_LISTS')
			  
	;WITH UPD_CLN AS
	(
		select ID, REQUESTED_DATE, BED_UID,
         row_number() over(order by BED_UID, REQUESTED_DATE ) as NO_ROW
		from BED_CLEAN	
		where WARD_UID IN ('@WARD_UID_LISTS')
	)
	
	UPDATE CLN
		SET ACCEPTED_BY = ISNULL(ACCEPTED_BY, 'BMS BED CLEAN has been accepted by system.'),
		ACCEPTED_DATE = ISNULL(ACCEPTED_DATE, CLN.REQUESTED_DATE),
		COMPLETED_BY = 'BMS BED CLEAN has been completed by system.',
		COMPLETED_DATE = ISNULL(ACCEPTED_DATE, CLN.REQUESTED_DATE),
		COMMENT = 'A newer bed clean request has been made for this bed.',
		COMMENTED_BY = 'BMS BED CLEAN has been commented by system.',
		COMMENTED_DATE = NEXT_CLN.REQUESTED_DATE,
		LAST_EDITED_BY = 'BMS system.',
		LAST_EDIT_DATE = NEXT_CLN.REQUESTED_DATE
	FROM BED_CLEAN CLN
		INNER JOIN UPD_CLN AS CURRENT_CLN ON CURRENT_CLN.ID = CLN.ID
		INNER JOIN UPD_CLN AS NEXT_CLN ON NEXT_CLN.NO_ROW - 1 = CURRENT_CLN.NO_ROW AND NEXT_CLN.BED_UID = CURRENT_CLN.BED_UID
		LEFT OUTER JOIN #BED_CLEAN AS LAST_CLN ON LAST_CLN.ID = CLN.ID
	WHERE LAST_CLN.ID IS NULL AND (CLN.ACCEPTED_DATE IS NULL OR CLN.COMPLETED_DATE IS NULL)

	DROP TABLE #BED_CLEAN