SELECT
	[A].[ID] AS ACT_ID,
	[A].[CREATION_DATE] AS CREATION_DATE,
	[A].[PARENT_ACT_ID] AS PARENT_ACT_ID,
	[A].[FLOW_ID] AS FLOW_ID,
	[A].[DOMAIN_ID] AS DOMAIN_ID,
	[A].[IEN] AS IEN,
	[A].[PATIENT_UID] AS PATIENT_UID,
	[WL].[FACILITY_UID] AS FACILITY_UID,
	[WA].[CODE] AS WAITING_AREA_CODE,
	[WA].[CODE_SYSTEM] AS WAITING_AREA_CODE_SYSTEM,
	[WA].[CODE_SYSTEM_NAME] AS WAITING_AREA_CODE_SYSTEM_NAME,
	[WA].[DISPLAY_NAME] AS WAITING_AREA_DISPLAY_NAME,										
	[WL].[PROBLEM] AS PROBLEM,
	[FD].[CODE] AS FEE_DISPOSITION_CODE,
	[FD].[CODE_SYSTEM] AS FEE_DISPOSITION_CODE_SYSTEM,
	[FD].[CODE_SYSTEM_NAME] AS FEE_DISPOSITION_CODE_SYSTEM_NAME,
	[FD].[DISPLAY_NAME] AS FEE_DISPOSITION_DISPLAY_NAME,
	[CF].[CODE] AS CONTRACT_FEE_CODE,
	[CF].[CODE_SYSTEM] AS CONTRACT_FEE_CODE_SYSTEM,
	[CF].[CODE_SYSTEM_NAME] AS CONTRACT_FEE_CODE_SYSTEM_NAME,
	[CF].[DISPLAY_NAME] AS CONTRACT_FEE_DISPLAY_NAME,
	[AF].[CODE] AS AUTHORIZED_FEE_CODE,
	[AF].[CODE_SYSTEM] AS AUTHORIZED_FEE_CODE_SYSTEM,
	[AF].[CODE_SYSTEM_NAME] AS AUTHORIZED_FEE_CODE_SYSTEM_NAME,
	[AF].[DISPLAY_NAME] AS AUTHORIZED_FEE_DISPLAY_NAME,
	[RUF].[CODE] AS REASON_USING_FEE_CODE,
	[RUF].[CODE_SYSTEM] AS REASON_USING_FEE_CODE_SYSTEM,
	[RUF].[CODE_SYSTEM_NAME] AS REASON_USING_FEE_CODE_SYSTEM_NAME,
	[RUF].[DISPLAY_NAME] AS REASON_USING_FEE_DISPLAY_NAME,
	[WL].[FEE_COMMENTS] AS FEE_COMMENTS,
	[WL].[TYPE_OF_BED_WARD] AS TYPE_OF_BED_WARD,	
	[WL].[REQUESTED_BED_UID] AS REQUESTED_BED_UID,
	[WL].[REQUESTED_BED_DATE] AS REQUESTED_BED_DATE,
	[WL].[REQUESTED_DATE] AS REQUESTED_DATE,
	[WL].[VISTA_SITE_UID] AS VISTA_SITE_UID,
	[WL].[LAST_EDIT_BY] AS LAST_EDIT_BY
	FROM ACT A
	INNER JOIN WAITING_LIST WL ON A.ID = WL.ACT_ID
	LEFT JOIN CONCEPT AS WA ON WL.WAITING_AREA_ID = WA.ID
	LEFT JOIN CONCEPT AS FD ON WL.FEE_DISPOSITION_ID = FD.ID
	LEFT JOIN CONCEPT AS CF ON WL.CONTRACT_FEE_ID = CF.ID
	LEFT JOIN CONCEPT AS AF ON WL.AUTHORIZED_FEE_ID = AF.ID
	LEFT JOIN CONCEPT AS SRF ON WL.SERVICE_RECEIVING_FEE_ID = SRF.ID
	LEFT JOIN CONCEPT AS RUF ON WL.REASON_USING_FEE_ID = RUF.ID
	LEFT JOIN CONCEPT AS EDS ON EDS.ID = WL.EVACUATION_DISPOSITION_STATUS_ID
	LEFT JOIN CONCEPT AS ETT ON ETT.ID = WL.EVACUATION_TRANSPORTATION_TYPE_ID
	LEFT JOIN CONCEPT AS ETP ON ETP.ID = WL.EVACUATION_TRANSPORTATION_PROVIDER_ID
WHERE FACILITY_UID = '@FACILITY_UID' AND REMOVED_DATE IS NULL 