SELECT DISTINCT 
	[A].[ID] AS ACT_ID ,
	[A].[CREATION_DATE] AS CREATION_DATE,
	[A].[CANCELED_DATE] AS CANCELED_DATE,
	[A].[PARENT_ACT_ID] AS PARENT_ACT_ID,
	[A].[FLOW_ID] AS FLOW_ID,
	[A].[DOMAIN_ID] AS DOMAIN_ID,
	[A].[IEN] AS IEN,		
	[TOCC].[CODE] AS TYPE_CODE,
	[TOCC].[CODE_SYSTEM] AS TYPE_CODE_SYSTEM,
	[TOCC].[CODE_SYSTEM_NAME] AS TYPE_CODE_SYSTEM_NAME,
	[TOCC].[DISPLAY_NAME] AS TYPE_DISPLAY_NAME,
	[ROCC].[CODE] AS REASON_CODE,
	[ROCC].[CODE_SYSTEM] AS REASON_CODE_SYSTEM,
	[ROCC].[CODE_SYSTEM_NAME] AS REASON_CODE_SYSTEM_NAME,
	[ROCC].[DISPLAY_NAME] AS REASON_DISPLAY_NAME,
	[BU].[BED_UID] AS BED_UID,
	[BU].[CREATIONBY] AS CREATED_BY,
	[BU].[EDITEDBY] AS EDITED_BY,
	[BU].[EDITED_DATE] AS EDITED_DATE,
	[BU].[COMPLETEDBY] AS COMPLETED_BY,
	[BU].[COMPLETED_DATE] AS COMPLETED_DATE,
	[BU].[IS_UNAVAILABLE_FROM_VISTA] AS IS_UNAVAILABLE_FROM_VISTA,		
	[BU].EXPECTED_COMPLETED_DATE AS EXPECTED_COMPLETED_DATE 	
FROM ACT A
INNER JOIN BED_UNAVAILABLE AS BU ON A.ID = BU.ACT_ID
INNER JOIN BED_UNAVAILABLE_WARD AS BU_WARD ON BU_WARD.BED_UNAVAILABLE_ID = BU.ACT_ID
LEFT JOIN CONCEPT AS TOCC ON BU.TYPE_ID = TOCC.ID
LEFT JOIN CONCEPT AS ROCC ON BU.REASON_ID = ROCC.ID
WHERE BU.COMPLETED_DATE IS NULL AND BU_WARD.WARD_UID IN ('@WARD_UID_LIST') AND (BU.IS_UNAVAILABLE_FROM_VISTA IS NULL OR BU.IS_UNAVAILABLE_FROM_VISTA = 0)
