DECLARE @ID INT, @BED_UID UNIQUEIDENTIFIER, @EVENT_TYPE NVARCHAR(10), @BED_CLEAN_ALREADY_EXISTS NVARCHAR(10)
SET @ID = NULL
SET @EVENT_TYPE = NULL
SET @BED_CLEAN_ALREADY_EXISTS = 'FALSE'

SELECT @ID = ID, @BED_UID = BED_UID
FROM DISCHARGE_EVN
WHERE IEN = '@BED_CLEAN_IEN' AND VISTA_SITE_UID = '@BED_CLEAN_VISTA_STE_UID' AND WARD_UID = '@BED_CLEAN_WARD_UID'

IF @ID IS NOT NULL
	BEGIN
		SET @EVENT_TYPE = 'DIS'
	END
ELSE
	BEGIN
	 SELECT @ID = ID, @BED_UID = OLD_BED_UID
	 FROM MOVEMENT_EVN
	 WHERE IEN = '@BED_CLEAN_IEN' AND VISTA_SITE_UID = '@BED_CLEAN_VISTA_STE_UID' AND OLD_WARD_UID = '@BED_CLEAN_WARD_UID'
	 
		 IF @ID IS NOT NULL
			BEGIN
				SET @EVENT_TYPE = 'TRA'
			END
		ELSE
			BEGIN
				SET @EVENT_TYPE = NULL
				SET @BED_UID = NULL
			END 
	END

IF @BED_UID IS NOT NULL AND @EVENT_TYPE IS NOT NULL
	BEGIN
		IF (SELECT COUNT(*) FROM BED_CLEAN 
		    WHERE BED_UID = @BED_UID AND VISTA_SITE_UID = '@BED_CLEAN_VISTA_STE_UID' 
				AND WARD_UID = '@BED_CLEAN_WARD_UID' AND EVENT_TYPE = @EVENT_TYPE AND EVENT_IEN = '@BED_CLEAN_IEN') <> 0
		 BEGIN
		   SET @BED_CLEAN_ALREADY_EXISTS ='TRUE'
		 END
	END

SELECT @EVENT_TYPE AS EVENT_TYPE, @BED_UID AS BED, @BED_CLEAN_ALREADY_EXISTS AS BED_CLEAN_ALREADY_EXISTS

	
	