﻿using System;
using System.Diagnostics;

namespace ImportUsers
{
    public class Tracer
    {
        private const string START_LINE = "**************************** {0:MM/dd/yyyy hh:mm:ss.fff tt} ***************************";
        private const string END_LINE = "----------------------------------------------------------------------------";

        public static void TraceException(Exception exception)
        {
            AppendStartLine();
            Trace.WriteLine(exception.Message);
            Type exceptionType = exception.GetType();
            bool parseRecursive = true;

            while (parseRecursive == true && exception.InnerException != null)
            {
                exception = exception.InnerException;
                Trace.WriteLine(exception.Message);
            }
            Trace.WriteLine(exception.StackTrace);
            AppendEndLine();                        
        }

        public static void TraceMessage(string customMessage)
        {            
            AppendStartLine();
            Trace.WriteLine(customMessage);
            AppendEndLine();            
        }        

        static void AppendStartLine()
        {
            Trace.WriteLine(String.Format(START_LINE, DateTime.Now));            
        }

        static void AppendEndLine()
        {            
            Trace.WriteLine(END_LINE);            
        }
    }
}
