DECLARE @VISTA_CODE NVARCHAR(20), @VISTA_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'
		SELECT @VISTA_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
		WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

		CREATE TABLE #ORGANIZATION(ID INT)
		INSERT INTO #ORGANIZATION(ID)
		SELECT O.PFK_ORGANIZATION FROM BMS_EIS.dbo.EHL7_ORGANIZATION O
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND CLASS_CODE = 'MBR'
		INNER JOIN BMS_EIS.dbo.ENTITY AS VS ON R.FK_SCOPER_ENTITY = VS.PK_ENTITY
		WHERE  O.CODE_CODE = 'HLOC' AND VS.IDENTIFIER = @VISTA_UID

		--DELETE TELECOM
		CREATE TABLE #ENTITY_TELECOM(PK_ENTITY_TELECOM INT, FK_TELECOM INT)
		INSERT INTO #ENTITY_TELECOM(PK_ENTITY_TELECOM, FK_TELECOM)
		SELECT EET.PK_ENTITY_TELECOM, EET.FK_TELECOM FROM BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = EET.FK_ENTITY

		DELETE EET FROM BMS_EIS.dbo.EHL7_ENTITY_TELECOM AS EET
		INNER JOIN #ENTITY_TELECOM AS DEL ON DEL.PK_ENTITY_TELECOM = EET.PK_ENTITY_TELECOM
		
		DELETE ET FROM BMS_EIS.dbo.EHL7_TELECOM AS ET
		INNER JOIN #ENTITY_TELECOM AS DEL ON DEL.FK_TELECOM = ET.PK_TELECOM

		DROP TABLE #ENTITY_TELECOM

		--DELETE ROLE
		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY

		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = ROL.FK_SCOPER_ENTITY
		
		--DELETE TRAIT
		DELETE TV FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = TV.FK_ENTITY
		
		--DELETE UID
		DELETE OUID FROM BMS_EIS.dbo.EHL7_UID AS OUID
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = OUID.FK_ENTITY

		--DELETE ORGANIZATION
		DELETE O FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = O.PFK_ORGANIZATION

		--DELETE ENTITY
		DELETE E FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN #ORGANIZATION AS DEL ON DEL.ID = E.PK_ENTITY

		DROP TABLE #ORGANIZATION

		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 1
	SELECT 'Hospital Location - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
	



