﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.StressInput;
using System.Runtime.Serialization;
using System.IO;
using BMS.Facade.Data;
using BMS.ServicesWrapper.WF;
using BMS.ServicesWrapper.Proxy.WF;
using System.Reflection;
using InfoWorld.HL7.ITS;

namespace BMS.StressTest
{
    class Program
    {
        static Input inputObj;

        enum Methods
        {
            CreateTransferRequest,
            UpdateTransferRequest,
            CreateTransferEvent
        }

        static void Main(string[] args)
        {
            string wfName = System.Configuration.ConfigurationManager.AppSettings["Workflow"];
            
            if (wfName.ToUpper() == "ADMISSION")
            {
                Deserialize("c:/Admission.xml");
                BMSWorkflowsWFIBMSFlowClient obj = new BMSWorkflowsWFIBMSFlowClient();

                foreach (Admission adm in inputObj.AdmissionList)
                {
                    WFFactory.BMSWorkflowClientWindows.CreateAdmissionRequest(adm);
                    //MethodInfo methodInfo = typeof(BMSWorkflowsWFIBMSFlowClient).GetMethod(inputObj.MethodName);
                    //methodInfo.Invoke(obj, new object[] { adm });
                }

                Console.WriteLine("Admission succeeded.");
                Console.ReadKey();
            }
            else
                if (wfName.ToUpper() == "TRANSFER")
                {
                    Deserialize("c:/Transfer.xml");
                    II transferId = new II();
                    Dictionary<II, Transfer> dic = new Dictionary<II, Transfer>();
                    
                    foreach (Transfer trans in inputObj.TransferList)
                    {
                        if (inputObj.MethodName == Methods.CreateTransferRequest.ToString())
                        {
                            transferId = WFFactory.TransferWorkflowClientWindows.CreateTransferRequest(trans);
                            dic.Add(transferId, trans);                          
                           
                        }
                        else
                            if (inputObj.MethodName == Methods.UpdateTransferRequest.ToString())
                                WFFactory.TransferWorkflowClientWindows.UpdateTransferRequest(trans);
                            else
                                if (inputObj.MethodName == Methods.CreateTransferEvent.ToString())
                                    WFFactory.TransferWorkflowClientWindows.CreateTransferEvent(trans);
                       
                     }

                    if (inputObj.MethodName == Methods.CreateTransferRequest.ToString())
                    {
                        foreach (KeyValuePair<II, Transfer> k in dic)
                        {
                            k.Value.Id = k.Key;
                            inputObj.TransferList.Add(k.Value);

                        }

                        Serialize("c:/Transfer.xml");
                    }

                    Console.WriteLine("Transfer succeeded.");
                    Console.ReadKey();
                 }
                
        }

        static void Deserialize(string filename)
        {
            using (FileStream reader = new FileStream(filename, FileMode.Open, FileAccess.Read))
            {
                DataContractSerializer ser = new DataContractSerializer(typeof(Input));
                inputObj = (Input)ser.ReadObject(reader);
            }
        }

        static void Serialize(string filename)
        {
            using (FileStream writer = new FileStream(filename, FileMode.Create, FileAccess.Write))
            {
                DataContractSerializer ser = new DataContractSerializer(typeof(Input));
                ser.WriteObject(writer, inputObj);
            }
        }
    }
}
