﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators.CalendarValidators
{
    public class DailyRecurs : IDateTimeValidator
    {
        public int RecursEvery { get; private set; }

        private DateTime currentDay;
        private DateTime nextDay;

        public DailyRecurs(int recursEvery)
        {
            RecursEvery = recursEvery;
        }

        private bool CheckRecursEvery(DateTime now)
        {
            DateTime day = now.Date;
            if (day == currentDay)
                return true;
            if (day == nextDay)
            {
                currentDay = nextDay;
                nextDay = nextDay.AddDays(RecursEvery);
                return true;
            }
            return false;
        }

        public bool IsValid(DateTime now)
        {
            bool result = CheckRecursEvery(now);
            return result;
        }

        public void Init(DateTime dateTimeStarted)
        {
            currentDay = dateTimeStarted.Date.AddDays(-1);
            nextDay = currentDay.AddDays(RecursEvery);
        }

    }
}
