﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.Fields;
using Mdws2ORM.Maps.BaseFields;

namespace Mdws2ORM.Maps.SingleMaps
{


    public class SingleSubEntityMap<V> : SubEntityMap<Container<V>>
    {


        private readonly string file;
        private readonly BaseFieldMap<Container<V>> fieldMap;

        public SingleSubEntityMap(BaseFieldMap<Container<V>> fieldMap, string file)
        {
            this.file = file;
            this.fieldMap = fieldMap;
        }

        public override string File
        {
            get { return file; }
        }

        protected override void MapFields()
        {
            Map(fieldMap);
        }

        public override Container<V> NewEntity(string ien)
        {
            return new Container<V>(ien);
        }


    }
}
