﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.Fields;
using Mdws2ORM.Maps.BaseFields;

namespace Mdws2ORM.Maps.SingleMaps
{
    public class SingleEntityMap<V> : EntityMap<Container<V>>
    {
        private readonly string file;
        private readonly string location;
        private readonly BaseFieldMap<Container<V>> fieldMap;

        public SingleEntityMap(BaseFieldMap<Container<V>> fieldMap, string file, string location)
        {
            this.file = file;
            this.location = location;
            this.fieldMap = fieldMap;
        }

        public override string File
        {
            get { return file; }
        }

        protected override void MapFields()
        {
            Map(fieldMap);
        }

        public override Container<V> NewEntity(string ien)
        {
            return new Container<V>(ien);
        }

        public override string Location
        {
            get { return location; }
        }
        
    }
}
