﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class DateTimeFieldMap<T> : BaseFieldMap<T> where T : class
    {
        private readonly Action<T, DateTime> MapAction;

        public DateTimeFieldMap(string field, Action<T, DateTime> mapAction)
            : base(field)
        {
            MapAction = mapAction;
        }

        public override void Map(IEntityQuery query, T entity, string value)
        {
            DateTime dateTime =  Converters.ToDateTime( value );
            MapAction(entity, dateTime);
        }
    }
}
