﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Core;

namespace Mdws2ORM.Impl
{
    public class Cache : ICache
    {
        private Dictionary<Type, object> cache = new Dictionary<Type, object>();


        public T Get<T>(string ien) where T : class
        {
            Type type = typeof(T);
            object value;
            cache.TryGetValue(type, out value);
            if (value == null)
                return null;
            Dictionary<string, T> dictionary = value as Dictionary<string, T>;
            T result;
            dictionary.TryGetValue(ien, out result);
            return result;
        }
    

        public bool Add<T>(string ien, T entity) where T : class
        {
            Type type = typeof(T);
            object value;
            if (!cache.TryGetValue(type, out value))
                return false;

            Dictionary<string, T> dictionary;
            if (value == null)
            {
                dictionary = new Dictionary<string, T>();
                cache[type] =  dictionary;
            }

            else dictionary = value as Dictionary<string,T>;
            if (dictionary.ContainsKey(ien))
                dictionary[ien] = entity;
            else
                dictionary.Add(ien, entity);
            return true;
        }

        public void AddCacheForType(Type type)
        {
            if (cache.ContainsKey(type))
                return;

            cache[type] = null;
        }

        public void RemoveCacheForType(Type type)
        {
            cache.Remove(type);
        }

        public void ResetCache()
        {
            cache.Keys.ForEach(k => cache[k] = null);
        }

        public void ResetCacheForType<T>() where T : class
        {
            Type type = typeof(T);
            if (!cache.ContainsKey(type))
                throw new InvalidOperationException();

            cache[type] = null;
        }
    }
}
