﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Core
{
    public class InitMapMediator
    {
        public InitMapMediator(IEntityMapRepository entityMapRepository, IFieldsParamFactory fieldsParamFactory)
        {
            this.EntityMapRepository = entityMapRepository;
            this.FieldsParamFactory = fieldsParamFactory;
        }

        public IEntityMapRepository EntityMapRepository { get; internal set; }
        public IFieldsParamFactory FieldsParamFactory { get; internal set; }


        public BaseEntityMap<T> GetBaseEntityMap<T>() where T : class
        {
            BaseEntityMap<T> entityMap = EntityMapRepository.GetEntityMap<T>();
            if (entityMap == null)
                throw new MdwsException("No base entity map found for " + typeof(T).FullName);

            return entityMap;
        }

        public EntityMap<T> GetEntityMap<T>() where T : class
        {
            EntityMap<T> entityMap = EntityMapRepository.GetEntityMap<T>() as EntityMap<T>;
            if (entityMap == null)
                throw new MdwsException("No entity map found for " + typeof(T).FullName);

            return entityMap;
        }

        public SubEntityMap<T> GetSubEntityMap<T>() where T : class
        {
            SubEntityMap<T> entityMap = EntityMapRepository.GetEntityMap<T>() as SubEntityMap<T>;
            if (entityMap == null)
                throw new MdwsException("No sub entity map found for " + typeof(T).FullName);

            return entityMap;
        }

        public string MakeListFieldsParam(string[] fields)
        {
            return FieldsParamFactory.MakeListFieldsParam(fields);
        }

        public string MakeGetFieldsParam(string[] fields)
        {
            return FieldsParamFactory.MakeGetFieldsParam(fields);
        }

        public IEnumerable<Type> GetTypes()
        {
            return EntityMapRepository.GetTypes();
        }


    }
}
