﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Exceptions;

namespace Mdws2ORM
{
    public static class Converters
    {
        public static string ToInternalFormat(DateTime dateTime)
        {
            string year = (dateTime.Year - 1700).ToString("000");
            string otherInfo = dateTime.ToString("MMdd.HHmmss").TrimEnd('0');
            otherInfo = otherInfo.TrimEnd('.');
            return year + otherInfo;
        }

        private static void CheckEmptyValue(string value)
        {
            if (String.IsNullOrEmpty(value))
                throw new ArgumentNullException("value");
        }

        public static DateTime ToDateTime(string value)
        {
            CheckEmptyValue(value);
            int year=0, month=0, day=0, hours=0, minutes=0, seconds=0;
            try
            {
                DateTime result, dt; decimal dateTime;
                if (decimal.TryParse(value, out dateTime))
                {
                    int date = (int)dateTime;
                    int time = (int)((dateTime - (decimal)date) * 1000000);
                    day = date % 100;
                    if (day == 0) day = 1;
                    date /= 100;
                    month = date % 100;
                    if (month == 0) month = 1;
                    date /= 100;
                    year = date + 1700;
                    if (time == 0)
                        result = new DateTime(year, month, day);
                    else
                    {
                        seconds = time % 100;
                        time /= 100;
                        minutes = time % 100;
                        time /= 100;
                        hours = time;
                        //aparently there are dates in vista that have the value 24 for the hour.
                        if (hours >= 24) hours = 0;
                        result = new DateTime(year, month, day, hours, minutes, seconds);
                    }
                }
                else if (DateTime.TryParse(value, out dt))
                    result = dt;
                else
                    throw new FormatException(string.Format("Mdws2ORM.Converters.ToDateTime: Input {0} cannot be converted to DateTime!", value));
                return result;
            }
            catch (Exception e)
            {
                throw new DataException(string.Format("Invalid input. Field value {0} cannot be converted to datetime. year:{1} month:{2} day:{3} hours:{4} minutes:{5} seconds:{6}", value, year, month, day, hours, minutes, seconds), e);
            }
        }

        public static bool ToBool(string value)
        {
            CheckEmptyValue(value);
            try
            {
                return !value.Equals("0");
            }
            catch (Exception e)
            {
                throw new DataException(string.Format("Invalid input. Field value {0} cannot be converted to bool.", value), e);
            }

        }

        public static string GetVariablePointerValue(string value)
        {
            CheckEmptyValue(value);
            try
            {
                int index = value.IndexOf(';');
                return value.Substring(0, index);
            }
            catch (Exception e)
            {
                throw new DataException(string.Format("Invalid input. Field value {0} is not an variable pointer type.", value), e);
            }
        }

        public static string GetVariablePointerType(string value)
        {
            CheckEmptyValue(value);
            try
            {
                int index = value.IndexOf(';');
                return value.Substring(index + 1);
            }
            catch (Exception e)
            {
                throw new DataException(string.Format("Invalid input. Field value {0} is not an variable pointer type.", value), e);
            }
        }
    }
}
