 USE BMS_EVS

 IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'_ssis_timestamp' AND Object_ID = Object_ID(N'voc_nested_value_set'))
BEGIN
	ALTER TABLE voc_nested_value_set ADD _ssis_timestamp DATETIME NULL
	ALTER TABLE voc_nested_value_set ADD  CONSTRAINT [DF_voc_nested_value_set__ssis_timestamp] DEFAULT (getdate()) FOR [_ssis_timestamp]
END
GO

IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'_ssis_timestamp' AND Object_ID = Object_ID(N'conceptProperty'))
BEGIN
	ALTER TABLE conceptProperty ADD _ssis_timestamp DATETIME NULL
	ALTER TABLE conceptProperty ADD  CONSTRAINT [DF_conceptProperty__ssis_timestamp] DEFAULT (getdate()) FOR [_ssis_timestamp]
END
GO

IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[ON_UPDATE_VS_CONCEPT]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[ON_UPDATE_VS_CONCEPT]
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[ON_UPDATE_VS_CONCEPT]
@VALUE_SET_ID	VARCHAR(100),
@fk_vs_concept int,
@HeadCodeChanged bit,
@associationChanged bit,
@includeReferencedNodeChanged bit,
@leafonlyChanged bit,
@directChildrenOnlyChanged bit
AS
SET NOCOUNT ON

declare @association Varchar(1000),@relationName varchar(100),
		@conceptCode varchar(100), @leafonly bit,@directChildrenOnly bit,
		@isHeadCode bit,
		@codeSystemName varchar(100),
		@includeReferencedCode bit


select @association= vc.association,
	   @relationName = vc.RelationName,
	   @conceptCode= vc.referencesConceptCode,
	   @leafonly = vc.leafOnly,
	   @directChildrenOnly = vc.directChildrenOnly,
	   @isHeadCode = isHeadCode,
	   @codeSystemName = vs.codingSchemeName,
	   @includeReferencedCode = includeReferencedCode
from VOC_code_reference vc 
inner join VOC_value_set vs on vs.valueSetId = @VALUE_SET_ID
where vc.pk = @fk_vs_concept		

if @associationChanged = 1 or  (@directChildrenOnlyChanged =1 and @directChildrenOnly = 1 and @association is not null)
begin

	declare @oldHEadCode bit 
	if (@HeadCodeChanged = 0 and @isHeadCode = 1)
		or 
		(@HeadCodeChanged = 1 and @isHeadCode = 0)
		select @oldHeadCode = 1
	else
		select @oldHEadCode = 0
		
		
	;
	
	declare @l int
	select @l = case when @oldHEadCode = 1 then 0 else 1 end
	;
	with outerVS(vsUid,valueSetID,uid)
		as
		(
			select vsn.uid,vsn.valueSetID,Substring(child.uid,1,len(child.uid)-4)
			from  voc_nested_value_set vsn 
			inner join dbo.f_outer_value_setS(@VALUE_SET_ID)   vs on vs.valueSetID = vsn.valueSetID
			outer apply (select top(1) child.uid 
						 from voc_nested_value_set child 
						 where child.valueSetId = vsn.valueSetId 
							   and child.uid <= vsn.uid + 0x00000001 +0xFFFFFFFF
								and child.uid >vsn.uid 
							   and child.level = vsn.level + 1
							   and child.fk_code_reference is null 
						 )as child
			where vsn.level = (vs.level +@l) and vsn.valueSetID = vs.valueSetId and fk_code_reference = @fk_vs_concept and vsn.conceptCode = @conceptCode
	)

	delete voc_nested_value_set 
--	select *  
	from voc_nested_value_Set vse 
	inner join outerVS n on n.valueSetID = vse.valueSetID 
	where (vse.uid = n.uid and @oldHEadCode = 0) or (vse.uid > n.uid and vse.uid <=n.uid + 0xFFFFFFFF)
	if @oldHEadCode  = 1
	begin
		update VOC_nested_value_set
		set conceptCode = null, codingSchemeName = null,fk_code_reference = null
		from  voc_nested_value_set vsn 
 		inner join dbo.f_outer_value_setS(@VALUE_SET_ID)   vs on vs.valueSetID = vsn.valueSetID
 		where vsn.level = vs.level and vsn.valueSetID = vs.valueSetId and fk_code_reference = @fk_vs_concept and vsn.conceptCode = @conceptCode and isNestedRoot = 1
	end
	exec ON_INSERT_VS_CONCEPT @value_Set_id,@fk_vs_concept
	return	
end

if @HeadCodeChanged = 1
begin
	
	
	declare @tempTable table(uid varbinary(8000),valueSetID varchar(100),_level int)

	
	declare @calcIsExpandable bit
	

	if @isHeadCode = 1
	begin
		select @calcIsExpandable = dbo.F_TEST_VALUE_SET_EXPAND(@value_set_id)	
		delete  voc_nested_value_set 
		where valueSetId = @VALUE_SET_ID and nestedValueSetID = @VALUE_SET_ID and isNestedRoot = 1 
		
		;
		with outerVS (valueSetID,includeHeadCode,level)
				as
				(
					select @VALUE_SET_ID,cast(1 as bit) ,0
					union all 
					select parent.usedToBuildValueSet,parent.includeHeadCode,child.level+1
					from VOC_value_set_constructor parent
					inner join outerVS child on child.valueSetId = parent.includesOrExcludesSet
				)
				
		update  voc_nested_value_set 
		set isExpandable = @calcIsExpandable,
			nodeType = case when outerVS.includeHeadCode = 0 or @includeReferencedCode = 0
								then 'A'
							else
								case when @calcIsExpandable=1 then 'S'  else 'L' end
						end	,
			level =vsn.level - 1,
			uid = Substring(uid,1,len(uid)-8),
			isNestedRoot = 1
		output deleted.uid,deleted.valueSetID,deleted.level into @tempTable
		from voc_nested_value_set vsn 
		inner join outerVS on outerVS.valueSetId = vsn.valueSetID
		where  vsn.fk_code_reference = @fk_vs_concept
				 and vsn.nestedValueSetID = @value_Set_id   and vsn.level = outerVs.level + 1

		if @association is not null 
		begin
		
			if @directChildrenOnlyChanged = 1 -- @direChildreOnly = 0 
			delete
			voc_nested_value_set 
			from voc_nested_value_set vsn 
			inner join @tempTable t on 
						vsn.uid > t.uid 
						and vsn.uid <= t.uid + 0xFFFFFFFF 
						and t.valueSetId = vsn.valueSetID 
			where vsn.level > t._level + 2
			
			update
			voc_nested_value_set
			set level =  level - 1 ,
				nodeType = case when @leafonlyChanged =0 and @directChildrenOnlyChanged =0 then nodeType else dbo.F_NODE_TYPE(1,0,@directChildrenOnly,@leafOnly,vsn.isExpandable)end
				,isExpandable = case when @directChildrenOnly = 1 then 0 else isExpandable end
			from voc_nested_value_set vsn 
			inner join @tempTable t on 
						vsn.uid > t.uid
						and vsn.uid <= t.uid+0xFFFFFFFF 
						and t.valueSetId = vsn.valueSetID 
			--else @direChildreOnly = 0 
			
			
		end 

		delete @tempTable
		
	end	
	else ----------------is headCode = 0
	begin
		select @calcIsExpandable = dbo.F_TEST_CODE_EXPAND(@conceptCode,@codeSystemName,@association,@relationName)

		declare @id int ,@uid varbinary(8000)
		select @id = DBO.f_get_next_rank_for_code_vs(@VALUE_SET_ID,case when @association = null then 0 else 1 end)
		;
		if @association is not null
			select @uid = cast(1 as varbinary(4)) + cast(@id as varbinary(4))
		else
			select @uid = cast(2 as varbinary(4)) + cast(@id as varbinary(4))
			
			select @uid 
		;
		
		with outerVS(vsUid,valueSetID,uid)
		as
		(
			select vsn.uid,vsn.valueSetID,Substring(child.uid,1,len(child.uid)-4)
			from  voc_nested_value_set vsn 
			inner join dbo.f_outer_value_setS(@VALUE_SET_ID)   vs on vs.valueSetID = vsn.valueSetID
			outer apply (select top(1) child.uid 
						 from voc_nested_value_set child 
						 where child.valueSetId = vsn.valueSetId 
							   and child.uid <= vsn.uid + 0x00000001 +0xFFFFFFFF
								and child.uid >vsn.uid 
							   and child.level = vsn.level + 1
							   and child.fk_code_reference is null 
						 )as child
			where vsn.level = vs.level and vsn.valueSetID = vs.valueSetId and nestedValueSetID = @VALUE_SET_ID and isNestedRoot = 1 and fk_code_reference = @fk_vs_concept
		)
		insert into   voc_nested_value_set (uid, valueSetID, conceptCode, nestedValueSetID, isExpandable, nodeType, level, isNestedRoot, codingSchemeName, fk_code_reference)
		output Inserted.uid ,Inserted.valueSetID,inserted.level into @tempTable
		select	
			coalesce (outerVS.uid,vsn.uid + @uid),
			outerVs.valueSetId,
			@conceptCode ,
			@VALUE_SET_ID,
			@calcIsExpandable as IsExpandable,
			case when @includeReferencedCode=0 then 'A' 
				  else case when  @calcIsExpandable =1 then 'S' else 'L' end
			END , 
			vsn.level + 1,
			0,
			vsn.codingSchemeName,
			vsn.fk_code_reference
		from voc_nested_value_set vsn 
		inner join outerVS on outerVS.valueSetId = vsn.valueSetID
		where  vsn.uid  = outerVS.Vsuid
			
		
		if @association is not null 
		begin
			if @directChildrenOnlyChanged = 1 -- @direChildreOnly = 0 
			delete
			voc_nested_value_set 
			from voc_nested_value_set vsn 
			inner join @tempTable t on 
						vsn.uid > t.uid 
						and vsn.uid <= t.uid + 0xFFFFFFFF 
						and t.valueSetId = vsn.valueSetID 
			where vsn.level > t._level + 2
			
			update
			voc_nested_value_set 
			set level = level + 1 ,
				nodeType  = case when @leafonlyChanged =0 and @directChildrenOnlyChanged =0 then nodeType else dbo.F_NODE_TYPE(1,0,@directChildrenOnly,@leafOnly,vsn.isExpandable)end
			from voc_nested_value_set vsn 
			inner join @tempTable t on vsn.uid >t.uid  and vsn.uid <= t.uid + 0xFFFFFFFF and t.valueSetId = vsn.valueSetID
		end 
		
		update  voc_nested_value_set 
		set isExpandable = 1,conceptCode = null,nodeType = 'A',
			 fk_code_reference = null
		from voc_nested_value_set vsn
		cross join (select distinct valueSetID  from @tempTable)  as vs 
		where vsn.valueSetId =vs.valueSetid and vsn.nestedValueSetID = @VALUE_SET_ID and vsn.isNestedRoot = 1 
	end
		
	return
--	select @leafonlyChanged = 1 , @includeReferencedNodeChanged = 0 ,@directChildrenOnlyChanged =0
end


--isHeadCode = 0

if @leafonlyChanged = 1 and @association is not null 
begin
		with outerVS (valueSetID,uid)
		as
		(select vsn.valueSetID,vsn.uid
		 from voc_nested_value_set vsn
		 inner join dbo.f_outer_value_setS(@VALUE_SET_ID) VS on vs.valueSetID = vsn.valueSetID 
		 where nestedValueSetID = @VALUE_SET_ID and fk_code_reference = @fk_vs_concept				
		)
		update 
		voc_nested_value_Set
		set nodeType = dbo.f_node_type(1,0,@directChildrenOnly,@leafOnly,vsn.isExpandable)
		from voc_nested_value_Set vsn
		inner join outerVS on outerVS.valueSetId = vsn.nestedValueSetID
		where vsn.valueSetID = outerVS.valueSetId
			   and   vsn.uid  > outerVS.uid 
			  and vsn.uid <= outerVS.uid  + 0xFFFFFFFF 
end


if @includeReferencedNodeChanged = 1
begin
		update 
		voc_nested_value_Set
		set nodeType = dbo.f_node_type(1,0,@directChildrenOnly,@leafOnly,vsn.isExpandable)
		from voc_nested_value_Set vsn
		inner join dbo.f_outer_value_setS(@VALUE_SET_ID) outerVS on outerVS.valueSetID = vsn.valueSetID 
			  where  nestedValueSetID = @value_set_id
			  and fk_code_reference = @fk_vs_concept
end
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Updates an association between value set and concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'ON_UPDATE_VS_CONCEPT'
GO

IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[EXPAND_VALUE_SET_IN_TABLE]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[EXPAND_VALUE_SET_IN_TABLE]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[EXPAND_VALUE_SET_IN_TABLE]
@value_set_id varchar(100),
@start_id varbinary(4)
AS
SET NOCOUNT ON

if @start_id is null 
	select @start_id = cast(0 as varbinary(4))
;
with value_set(uid,valueSetID,[level],includeHeadCode,codingSchemeName,allCodes)
	AS 
	(
		select cast(@start_id  as varbinary(8000)) ,@value_set_id,0,cast(1 as bit),codingSchemeName,allCodes
		from	  VOC_value_set where valueSetId = @value_set_id
		UNION ALL
		select -- cast(vs.uid + (cast(cast (row_number()  over (PARTITION BY vs.valueSetID ORDER BY vc.usedToBuildValueSet) as tinyInt)as varbinary(1)) +0x000000) as varbinary(8000))
					 cast(vs.uid + cast (1000 + row_number()  over (PARTITION BY vs.valueSetID ORDER BY vc.usedToBuildValueSet)  as  varbinary(4))as varbinary(8000)) 
					,vc.includesOrExcludesSet,([level] ) +1, vc.includeHeadCode,
					vcs.codingSchemeName,vcs.allCodes
		from VOC_value_set_constructor  vc
		inner join value_set vs on vs.valueSetID = vc.usedToBuildValueSet 
		inner join VOC_value_set vcs on vcs.valueSetId = vc.includesOrExcludesSet
		--WHERE  @max_level=0 or [level]<@max_level
	)
insert into VOC_nested_value_set (uid, valueSetID, conceptCode, nestedValueSetID, isExpandable, nodeType, level, isNestedRoot, codingSchemeName, fk_code_reference)
select	
			--vs.uid +0x00 + cast(cast(rank()  over (PARTITION BY vs.valueSetId ORDER BY vcr.pk) as smallInt)as varbinary(2))+0x00 + ce.uid as huid
			vs.uid +cast (1 as varbinary(4))+ cast(dense_rank()  over (PARTITION BY vs.valueSetId ORDER BY vcr.pk)  as varbinary(4))+ ce.uid as huid
			,@value_set_id,
			ce.conceptCode ,
			vs.valueSetId,
			ex.isExpandable as IsExpandable,
			CASE 
							 when ex.IsExpandable =1
							 then   
									 case when (vcr.leafOnly = 1 and ce.level<>0) or (ce.level = 0 and vcr.includeReferencedCode=0)  then 'A' 
											else  case when vcr.directChildrenOnly = 1 and ce.level > 0 	then 'L' else 'S' end
									end
							 else 
								case when ce.level = 0 and vcr.includeReferencedCode=0 then 'A' else 'L' end
			END , 
			vs.level   + coalesce(1 - vcr.isHeadCode  +ce.[level],0) as level,
			0,
			vs.codingSchemeName,
			case when ce.level = 0 then vcr.pk else null  end  as fk_code_reference
from  value_set  vs
inner join  voc_code_reference	  vcr on vcr.usedToBuildValueSet = vs.valueSetId 
cross apply   dbo.F_EXPAND_CONCEPT(vs.codingSchemeName,vcr.referencesConceptCode,vcr.association,vcr.directChildrenOnly,30000000,vcr.RelationName,0,
				vcr.isHeadCode,cast ('' as varbinary(4)))as ce
cross apply ( select   dbo. F_TEST_CODE_EXPAND(ce.conceptCode,vs.codingSchemeName,vcr.association,vcr.RelationName)
					as isExpandable) as ex
where   vcr.association is not null 
union  all 

select	
			vs.uid +cast (2 as varbinary(4))+ cast(row_number()  over (PARTITION BY vs.valueSetId ORDER BY vcr.referencesConceptCode) as varbinary(4)),
			@value_set_id,
			vcr.referencesConceptCode ,
			vs.valueSetId,
			0,
			case when vcr.includeReferencedCode =1 then 'L' else 'A' end,
			vs.level  + 1  as level,
			0,
			vs.codingSchemeName,
			vcr.pk as  fk_code_reference
from  value_set  vs
inner join  voc_code_reference	  vcr on vcr.usedToBuildValueSet = vs.valueSetId 
where   vcr.association is  null and vcr.isHeadCode = 0 

union  all

select 
		--3,vcr.isHeadCode,
		vs.uid,
		@value_set_id,
		vcr.referencesConceptCode,
		vs.valueSetId, 
		ex.isExpandable,
		CASE 
			WHEN vcr.referencesConceptCode is null  or vs.includeHeadCode = 0  or vcr.includeReferencedCode = 0 
			THEN 'A'
			ELSE 
					CASE 
						WHEN  ex.isExpandable = 1 
						THEN 'S'
						ELSE 'L'
					END
		END,
		vs.level,
		1,
		vs.codingSchemeName,
		vcr.pk as  fk_code_reference
from  value_set  vs 
left join  voc_code_reference	  vcr on vcr.usedToBuildValueSet = vs.valueSetId  and vcr.isHeadCode = 1 
cross apply (select  dbo.f_test_value_Set_expand(vs.valueSetID) as isExpandable) as ex

union all 
select -- 4,null,
		vs.uid +cast (4 as varbinary(4)) + cast(row_number()  over (PARTITION BY vs.valueSetId ORDER BY vs.valueSetID) as varbinary(4)),
		@value_set_id,
		c.conceptCode,
		vs.valueSetId,
		0, 
	    'L',
		vs.level +1 ,
		0,
		vs.codingSchemeName,
		null as  fk_code_reference
from  value_set  vs 
inner join  concept c on c.codingSchemeName = vs.CodingSchemeName 
where vs.allCodes = 1 and c.[conceptCode] <>'@'
order  by level
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Updates the value set values.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'EXPAND_VALUE_SET_IN_TABLE'
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[voc_nested_value_set]') AND name = N'idx_SSIS_TIMESTAMP_CODING_SCHEME_NAME')
BEGIN
CREATE NONCLUSTERED INDEX [idx_SSIS_TIMESTAMP_CODING_SCHEME_NAME] ON [dbo].[voc_nested_value_set] 
(
	[_ssis_timestamp] ASC,
	[codingSchemeName] ASC
)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[conceptProperty]') AND name = N'idx_SSIS_TIMESTAMP_CODING_SCHEME_NAME')
BEGIN
CREATE NONCLUSTERED INDEX [idx_SSIS_TIMESTAMP_CODING_SCHEME_NAME] ON [dbo].[conceptProperty] 
(
	[_ssis_timestamp] ASC,
	[codingSchemeName] ASC
)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

update voc_nested_value_set
	set _ssis_timestamp = DATEADD(day, -1, getdate())
where _ssis_timestamp is null
go

update conceptProperty
	set _ssis_timestamp = DATEADD(day, -1, getdate())
where _ssis_timestamp is null
go

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VALUESETID_PK_CONCEPTCODE_NODETYPE' AND object_id = OBJECT_ID('voc_nested_value_set')) = 0
BEGIN
CREATE INDEX [IDX_VALUESETID_PK_CONCEPTCODE_NODETYPE] ON [dbo].[voc_nested_value_set] 
([valueSetID],[pk], [conceptCode], [nodeType]) 
INCLUDE ([codingSchemeName])
END
GO