	USE [PERF_BMS_VISTA]
	
	DECLARE @minSID int = 10, @resetSID int = 10, @maxPatients int = 1000 
	DECLARE @tmp int, @patIen int
	

--INSERT PATIENTS(1000)
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpPatient') AND type in (N'U'))
		DROP TABLE tmpPatient
		
	CREATE TABLE tmpPatient(Pat_id int)
	
	WHILE @minSID < (@resetSID + @maxPatients) --10 < 1010
	BEGIN
		--select * 
		--FROM #tmpBed B join dbo.ROOM_BED RB on B.Bed_id = RB.IEN
		--WHERE B.Number = @minSID
		
		INSERT INTO [dbo].[PATIENT]
		   ([NAME],[WARD_LOCATION_ID],[ROOM_BED_ID],[SEX],[TREATING_SPECIALTY_NAME],[SOCIAL_SECURITY_NUMBER],[DATE_OF_BIRTH])
		 SELECT 'PAT, TAP ' + cast(@minSID as varchar),	WARDS_WHICH_CAN_ASSIGN_ID, RB.IEN, 'M', null, 
				 cast(100 + CONVERT(INT, (999-100+1)*RAND()) as varchar)
					+'-' + cast(10 + CONVERT(INT, (99-10+1)*RAND()) as varchar)
					+'-'+ cast(1000 + CONVERT(INT, (9999-1000+1)*RAND()) as varchar),
				dateadd(day,round(@minSID/10,0),'1950-01-01')
		FROM dbo.RMDB_WARDS_WITH_CAN_ASSIGN AS WB join dbo.ROOM_BED AS RB on WB.ROOM_BED_ID = RB.IEN
			join tmpBed B on B.Bed_id = RB.IEN
		 --FROM tmpBed B join dbo.ROOM_BED RB on B.Bed_id = RB.IEN
		 WHERE B.Number = @minSID --ROUND((@minSID - @resetSID)/@maxPatients, 0 , 1) + @resetSID
		 
		 INSERT INTO tmpPatient 
		 SELECT SCOPE_IDENTITY() as Pat_id 
		 
		 SELECT @patIen = Pat_id FROM tmpPatient
		 
-- ADMISSION

		-- Create Admission Order		 
		 INSERT INTO [dbo].[CPRS_ORDERS]
			   ([OBJECT_OF_ORDER]
			   ,[DATE_OF_LAST_ACTIVITY]
			   ,[ORDER_STATUS_ID]
			   ,[PATIENT_LOCATION_ID]
			   ,[ITEM_ORDERED]
			   ,[START_DATE]
			   ,[STOP_DATE]
			   ,[DC_DATE_TIME]
			   ,[TO_DISPLAY_GROUP_ID]
			   ,[ORDERABLE_ITEM_ID]
			   ,INTERNAL_UID)
		 SELECT P.NAME,
				'2012-05-08',
				1,
				WARD.HOSPITAL_LOCATION_ID,
				null,
				'2012-05-08',
				null,
				null,
				null,
				3, --ADMIT	
				newid()			
		 FROM PATIENT P join tmpPatient TMP ON P.IEN = TMP.Pat_id
				join WARD_LOCATION WARD ON P.WARD_LOCATION_ID = WARD.IEN
		 
		 SET @tmp = SCOPE_IDENTITY()
		 
		 INSERT INTO [dbo].[CPRS_ORDERS_ORDERABLE_ITEM]
           ([CPRS_ORDERS_ID],[ORDERABLE_ITEM_ID])
         VALUES (@tmp,3)
         
         INSERT INTO [dbo].[ORDER_ACTIONS]
           ([DATE_TIME_ORDERED]
           ,[ORDER_TEXT]
           ,[SIGNATURE_STATUS]
           ,[DATE_TIME_SIGNED]
           ,[SIGNED_BY_ID]
           ,[NEW_PERSON_NAME]
           ,[PROVIDER_ID]
           ,[DATE_TIME_NURSE_VERIFIED]
           ,[VERIFYING_NURSE_ID]
           ,[DATE_TIME_CLERK_VERIFIED]
           ,[VERIFYING_CLERK_ID]
           ,[RELEASE_DATE_TIME]
           ,[RELEASE_STATUS]
           ,[CPRS_ORDER_ID])
		VALUES	
			('2012-05-09',
			'admis',
			null,
			'2012-05-09',
			 1,
			 null,
			 2,
			 null, null, null, null,
			 '2012-05-09', null,
			 @tmp	
			)
			
		DELETE FROM tmpPatient
		--DELETE FROM tmpMovementData
		 
		SET @minSID += 1 
		 
	END 
	

-- Create Admission Event	
		declare @dtAdmissionEVN datetime, @dtAdmissionEVN_Start datetime, @dtAdmissionEVN_End datetime
		set @dtAdmissionEVN_Start = '2012-05-10'
		set @dtAdmissionEVN_End = '2012-05-15'

		SELECT @dtAdmissionEVN = @dtAdmissionEVN_Start +  (ABS( CAST(CAST( NewID() AS BINARY(8)) AS INT)) % CAST((@dtAdmissionEVN_End - @dtAdmissionEVN_Start) AS INT))
		 
		 INSERT INTO [dbo].[PATIENT_MOVEMENT]
           ([DATETIME]
           ,[ENTERED_ON_DATETIME]
           ,[ENTERED_BY_ID]
           ,[TRANSACTION_ID]
           ,[MAS_MOVEMENT_TRANS_NAME]
           ,[PATIENT_ID]
           ,[TYPE_OF_MOVEMENT_ID]
           ,[FAC_MOVE_TYPE_NAME]
           ,[WARD_LOCATION_ID]
           ,[ROOM_BED_ID]
           ,[ADMISSION_CHECK_IN_MOVEMENT_ID]
           ,[RELATED_PHYSICAL_MOVEMENT_ID]
           ,[WARD_AT_DISCHARGE]
           ,[TRANSACTION_]
           ,INTERNAL_UID)
		SELECT
			@dtAdmissionEVN,
			@dtAdmissionEVN,
			2,
			null,null,
			P.IEN,
			1,
			null,
			P.WARD_LOCATION_ID,
			P.ROOM_BED_ID,
			null, null, null,
			1, -- Admission
			newid()
		FROM PATIENT P --join tmpPatient TMP ON P.IEN = TMP.Pat_id
				join WARD_LOCATION WARD ON P.WARD_LOCATION_ID = WARD.IEN