SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[Log](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Date] [datetime] NOT NULL,
	[Thread] [varchar](255) NOT NULL,
	[Level] [varchar](50) NOT NULL,
	[Logger] [varchar](255) NOT NULL,
	[Message] [varchar](4000) NOT NULL,
	[Exception] [varchar](2000) NULL,
 CONSTRAINT [PK_Log] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

/****** Object:  Trigger [dbo].[utg_LOG_AfterInsert]    Script Date: 05/25/2012 10:44:55 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[utg_LOG_AfterInsert] 
   ON  [dbo].[Log] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @COMMA CHAR, @DIESE CHAR, @SEP CHAR, @COLUMN NVARCHAR(100), @COLUMNS NVARCHAR(MAX), @Message NVarchar(MAX), 
		@LEN int, @LAST_INDEX int, @VALUE NVARCHAR(500), @VALUES NVARCHAR(MAX), @EXCEPTION NVARCHAR(2000)
	DECLARE @SQL NVARCHAR(MAX)
    
    SELECT @COMMA = ',', @DIESE = '#', @COLUMNS = '(ID,', @VALUES = '(' + CAST(Id as NVARCHAR) + ',', @SQL = 'INSERT INTO LOG_DETAIL ', @Message= Message, @EXCEPTION = Exception
    FROM inserted
    
    IF @EXCEPTION IS NOT NULL AND LTRIM(@EXCEPTION) <> ''
		RETURN
    
	WHILE (LEN(@Message) > 0)
	BEGIN
		--GET THE COLUMN
		SET @LAST_INDEX = CHARINDEX(@DIESE, @MESSAGE)
		SET @COLUMN = SUBSTRING(@Message, 0, @LAST_INDEX)
		SET @LEN = LEN(@Message) - @LAST_INDEX
		SET @MESSAGE = SUBSTRING(@MESSAGE, @LAST_INDEX + 1, @LEN)
		--GET THE VALUE
		SET @LAST_INDEX = CHARINDEX(@COMMA, @MESSAGE)
		IF @LAST_INDEX = 0
		BEGIN
			SET @VALUE = @MESSAGE
			SET @MESSAGE = ''
			SET @SEP = ')'
		END
		ELSE
		BEGIN
			SET @VALUE = SUBSTRING(@Message, 0, @LAST_INDEX)
			SET @LEN = LEN(@Message) - @LAST_INDEX
			SET @MESSAGE = SUBSTRING(@MESSAGE, @LAST_INDEX + 1, @LEN)
			SET @SEP = ','
		END
		
		SET @COLUMNS += @COLUMN + @SEP
		IF @VALUE = ''
			SET @VALUES += 'NULL' + @SEP
		ELSE
			SET @VALUES += '''' + @VALUE + '''' + @SEP
	END
	SET @SQL += @COLUMNS + ' VALUES ' + @VALUES
	--insert into log_detail
	EXEC sp_executesql @SQL
	
END
GO