-- Columns

CREATE TABLE [dbo].[RMDB_WARDS_WITH_CAN_ASSIGN]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[WARDS_WHICH_CAN_ASSIGN_ID] [int] NOT NULL,
[ROOM_BED_ID] [int] NOT NULL,
[IENS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[RMDB_WARDS_WITH_CAN_ASSIGN] ADD CONSTRAINT [PK_RMDB_WARDS_WITH_CAN_ASSGN] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[RMDB_WARDS_WITH_CAN_ASSIGN] ADD CONSTRAINT [FK_RMDB_WARDS_WITH_CAN_ASSIGN_ROOM_BED] FOREIGN KEY ([ROOM_BED_ID]) REFERENCES [dbo].[ROOM_BED] ([IEN])
GO
ALTER TABLE [dbo].[RMDB_WARDS_WITH_CAN_ASSIGN] ADD CONSTRAINT [FK_RMDB_WARDS_WITH_CAN_ASSIGN_WARD_LOCATION] FOREIGN KEY ([WARDS_WHICH_CAN_ASSIGN_ID]) REFERENCES [dbo].[WARD_LOCATION] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'Table that contains the list of wards that can be assigned.', 'SCHEMA', N'dbo', 'TABLE', N'RMDB_WARDS_WITH_CAN_ASSIGN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier column of the table.', 'SCHEMA', N'dbo', 'TABLE', N'RMDB_WARDS_WITH_CAN_ASSIGN', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'List of concatenated identifiers.', 'SCHEMA', N'dbo', 'TABLE', N'RMDB_WARDS_WITH_CAN_ASSIGN', 'COLUMN', N'IENS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of bed.', 'SCHEMA', N'dbo', 'TABLE', N'RMDB_WARDS_WITH_CAN_ASSIGN', 'COLUMN', N'ROOM_BED_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of a ward which can be assigned.', 'SCHEMA', N'dbo', 'TABLE', N'RMDB_WARDS_WITH_CAN_ASSIGN', 'COLUMN', N'WARDS_WHICH_CAN_ASSIGN_ID'
GO