CREATE TABLE [dbo].[ROOM_BED]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CURRENTLY_OUT_OF_SERVICE] [bit] NOT NULL,
[OUT_OF_SERVICE_DATE] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[ROOM_BED_tgg_delete]
   ON  dbo.ROOM_BED
   AFTER delete
AS 
BEGIN	
		insert into [dbo].[ROOM_BED_LOG]([ACTION], IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE)
		select 'D', IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE from deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[ROOM_BED_tgg_insert]
   ON  dbo.ROOM_BED
   AFTER insert
AS 
BEGIN	
		insert into [dbo].[ROOM_BED_LOG]([ACTION], IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE)
		select 'I', IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE from inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[ROOM_BED_tgg_update]
   ON  dbo.ROOM_BED
   AFTER update
AS 
BEGIN	
		insert into [dbo].[ROOM_BED_LOG]([ACTION], IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE)
		select 'U', IEN, NAME, CURRENTLY_OUT_OF_SERVICE, OUT_OF_SERVICE_DATE from inserted;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[ROOM_BED] ADD CONSTRAINT [PK_ROOM_BED] PRIMARY KEY CLUSTERED  ([IEN])
GO

-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'The table contains room bed data.', 'SCHEMA', N'dbo', 'TABLE', N'ROOM_BED', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'True/False column for specifying that the bed id currently out of service or not.', 'SCHEMA', N'dbo', 'TABLE', N'ROOM_BED', 'COLUMN', N'CURRENTLY_OUT_OF_SERVICE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table''s id column.', 'SCHEMA', N'dbo', 'TABLE', N'ROOM_BED', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Bed''s name.', 'SCHEMA', N'dbo', 'TABLE', N'ROOM_BED', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the bed becomes out of service.', 'SCHEMA', N'dbo', 'TABLE', N'ROOM_BED', 'COLUMN', N'OUT_OF_SERVICE_DATE'
GO
