CREATE TABLE [System.Activities.DurableInstancing].[ServiceDeploymentsTable]
(
[Id] [bigint] NOT NULL IDENTITY(1, 1),
[ServiceDeploymentHash] [uniqueidentifier] NOT NULL,
[SiteName] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[RelativeServicePath] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[RelativeApplicationPath] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ServiceName] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ServiceNamespace] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE CLUSTERED INDEX [CIX_ServiceDeploymentsTable] ON [System.Activities.DurableInstancing].[ServiceDeploymentsTable] ([Id]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [NCIX_ServiceDeploymentsTable_ServiceDeploymentHash] ON [System.Activities.DurableInstancing].[ServiceDeploymentsTable] ([ServiceDeploymentHash]) WITH (IGNORE_DUP_KEY=ON, ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
