CREATE TABLE [System.Activities.DurableInstancing].[LockOwnersTable]
(
[Id] [uniqueidentifier] NOT NULL,
[SurrogateLockOwnerId] [bigint] NOT NULL IDENTITY(1, 1),
[LockExpiration] [datetime] NOT NULL,
[WorkflowHostType] [uniqueidentifier] NULL,
[MachineName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[EnqueueCommand] [bit] NOT NULL,
[DeletesInstanceOnCompletion] [bit] NOT NULL,
[PrimitiveLockOwnerData] [varbinary] (max) NULL CONSTRAINT [DF__LockOwner__Primi__7F60ED59] DEFAULT (NULL),
[ComplexLockOwnerData] [varbinary] (max) NULL CONSTRAINT [DF__LockOwner__Compl__00551192] DEFAULT (NULL),
[WriteOnlyPrimitiveLockOwnerData] [varbinary] (max) NULL CONSTRAINT [DF__LockOwner__Write__014935CB] DEFAULT (NULL),
[WriteOnlyComplexLockOwnerData] [varbinary] (max) NULL CONSTRAINT [DF__LockOwner__Write__023D5A04] DEFAULT (NULL),
[EncodingOption] [tinyint] NULL CONSTRAINT [DF__LockOwner__Encod__03317E3D] DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [NCIX_LockOwnersTable_Id] ON [System.Activities.DurableInstancing].[LockOwnersTable] ([Id]) WITH (IGNORE_DUP_KEY=ON, ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_LockOwnersTable_LockExpiration] ON [System.Activities.DurableInstancing].[LockOwnersTable] ([LockExpiration]) INCLUDE ([MachineName], [WorkflowHostType]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE UNIQUE CLUSTERED INDEX [CIX_LockOwnersTable] ON [System.Activities.DurableInstancing].[LockOwnersTable] ([SurrogateLockOwnerId]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_LockOwnersTable_WorkflowHostType] ON [System.Activities.DurableInstancing].[LockOwnersTable] ([WorkflowHostType]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
