IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Rpt_WaitingList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Rpt_WaitingList]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_Rpt_WaitingList]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NDNS  AR(500),
	@FACILITIES_IDS NDNS  AR(MAX) = '',
	@REPORT_TYPE NDNS  AR(50)
AS
BEGIN

	SET NOCOUNT ON;
	
	
	IF (@REPORT_TYPE = 'WAIT_LIST')
		BEGIN
	
		IF @DATE_FROM > @DATE_TO
			RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
		ELSE
		BEGIN
		
			set @DATE_FROM = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_FROM );
			set @DATE_TO = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_TO );

			--GET INFORMATION ABOUT SELECTED FACILITIES
			CREATE TABLE #TBL_FACILITY (SOURCE_ID NDNS  AR(250) PRIMARY KEY, FACILITY_NAME NDNS  AR(250), TIMEZONE_OFFSET INT)
			INSERT INTO #TBL_FACILITY(SOURCE_ID, FACILITY_NAME, TIMEZONE_OFFSET) 
			SELECT DISTINCT CONVERT(NDNS  AR(250), FACILITY.VALUE), ORG.NAME,  [dbo].[ufn_GetOffsetByFacilityUID](VALUE) 
			FROM dbo.ufn_Split(@FACILITIES_IDS, ',') AS FACILITY
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = FACILITY.VALUE 
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS ORG ON ORG.PFK_ORGANIZATION = ENTITY.PK_ENTITY

			--GET VOCABULARY WAITING AREA			
			CREATE TABLE #WAITING_AREA(PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NDNS  AR(250))
			INSERT INTO #WAITING_AREA(PK, SOURCE_ID, DISPLAY_NAME)
			SELECT MAX_WAITING_AREA.PK, MAX_WAITING_AREA.ID, CONCEPT.DISPLAY_NAME
			FROM (	
			SELECT MAX(PK) AS PK, ID
			FROM dbo.CONCEPT_H
			WHERE code_system_name = 'WaitingArea'
			GROUP BY ID) AS MAX_WAITING_AREA 
			INNER JOIN DBO.CONCEPT_H AS CONCEPT ON CONCEPT.PK = MAX_WAITING_AREA.PK
			
			--GET VOCABULARY FEE DISPOSITION
			CREATE TABLE #FEE_DISPOSITION  (PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NDNS  AR(250))
			INSERT INTO #FEE_DISPOSITION(PK, SOURCE_ID, DISPLAY_NAME)
			SELECT MAX_FEE_DISP.PK, MAX_FEE_DISP.ID, CONCEPT_D.DISPLAY_NAME
			FROM (
					SELECT MAX(PK) as PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'FeeDisposition'
					GROUP BY ID)  AS MAX_FEE_DISP 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_D ON CONCEPT_D.PK = MAX_FEE_DISP.PK
			
			--GET VOCABULARY STRICT DECISION
			CREATE TABLE #STRICT_DECISION (PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NDNS  AR(250))
			INSERT INTO #STRICT_DECISION(PK, SOURCE_ID, DISPLAY_NAME)				
			SELECT MAX_CONCEPT_CONTRACT._PK, MAX_CONCEPT_CONTRACT.ID, CONCEPT_C.DISPLAY_NAME
			FROM(
					SELECT MAX(PK) as _PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'StrictDecision'
					GROUP BY ID ) AS MAX_CONCEPT_CONTRACT 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_C ON CONCEPT_C.PK = MAX_CONCEPT_CONTRACT._PK
				
			--GET VOCABULARY VISTA SPECIALTY
			CREATE TABLE #VISTA_SPECIALTY(PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NDNS  AR(250))
			INSERT INTO #VISTA_SPECIALTY(PK, SOURCE_ID, DISPLAY_NAME)	
			SELECT MAX_CONCEPT_SERVICE._PK, MAX_CONCEPT_SERVICE.ID, CONCEPT_S.DISPLAY_NAME	
			FROM(
					SELECT MAX(PK) as _PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'VistaSpecialty'
					GROUP BY ID
					
				) AS MAX_CONCEPT_SERVICE 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_S ON CONCEPT_S.PK = MAX_CONCEPT_SERVICE._PK	
			
			--GET VOCABULARY FEE REASON
			CREATE TABLE #FEE_REASON (PK INT PRIMARY KEY, SOURCE_ID INT, DISPLAY_NAME NDNS  AR(250))
			INSERT INTO #FEE_REASON(PK, SOURCE_ID, DISPLAY_NAME)		
			SELECT MAX_CONCEPT_REASON._PK, MAX_CONCEPT_REASON.ID, CONCEPT_R.DISPLAY_NAME
			FROM (
					SELECT MAX(PK) as _PK, ID
					FROM dbo.CONCEPT_H
					WHERE code_system_name = 'FeeReason'
					GROUP BY ID
					
				) AS MAX_CONCEPT_REASON 
			INNER JOIN dbo.CONCEPT_H AS CONCEPT_R ON CONCEPT_R.PK = MAX_CONCEPT_REASON._PK
			
			--GET AVAILABLE INFORMATION ABOUT WAITING LIST HISTORY
			CREATE TABLE #HISTORY_WAITING_LIST
			(
			[PK] [int] NOT NULL PRIMARY KEY,
			[ACT_ID] [int] NOT NULL,
			[FACILITY_NAME] [NDNS  AR] (250) NULL,
			[PATIENT_UID] [UNIQUEIDENTIFIER] NULL,
			[BED_UID] [UNIQUEIDENTIFIER] NULL,
			[REQ_BED_DATE] [datetime] NULL,
			[PROBLEM] [nvarchar] (max) NULL,
			[TYPE_OF_BED_WARD] [nvarchar] (250) NULL,
			[WAITING_AREA] [NDNS  AR] (250) NULL,
			[FEE_DISPOSITION] [NDNS  AR] (250) NULL,
			[CONTRACT_FEE] [NDNS  AR] (250) NULL,
			[AUTH_FEE] [NDNS  AR] (250) NULL,
			[SERV_REC] [NDNS  AR] (250) NULL,
			[REASON] [NDNS  AR] (250) NULL,
			[COMMENTS] [nvarchar] (150)  NULL,
			[CREATED_BY] [nvarchar] (50) NULL,
			[DATE_FAC] [DATETIME] NULL,
			TRANSACTION_TYPE_CODE [varchar] (50) NULL
			) 
			CREATE UNIQUE INDEX IX_HISTORY_W_L_PK_ACT_ID ON #HISTORY_WAITING_LIST(PK, ACT_ID)
			CREATE UNIQUE NONCLUSTERED INDEX IX_HISTORY_W_L_FAC_NAME_ACT_ID_DATE_FAC ON #HISTORY_WAITING_LIST (FACILITY_NAME, ACT_ID, DATE_FAC) 
			
			INSERT INTO #HISTORY_WAITING_LIST(PK, ACT_ID, FACILITY_NAME, PATIENT_UID,
						BED_UID, REQ_BED_DATE, PROBLEM, TYPE_OF_BED_WARD, WAITING_AREA,
						FEE_DISPOSITION,CONTRACT_FEE,AUTH_FEE,SERV_REC, REASON,
						COMMENTS,CREATED_BY,DATE_FAC,TRANSACTION_TYPE_CODE)
			SELECT FIRST_ROW_COMPARED.PK, FIRST_ROW_COMPARED.ACT_ID, FAC.FACILITY_NAME,
					A.PATIENT_UID,
					FIRST_ROW_COMPARED.REQUESTED_BED_UID,
					DATEADD (minute, 
					ISNULL(fac.TIMEZONE_OFFSET * 60,
							@TIME_ZONE_MINUTES_OFFSET), FIRST_ROW_COMPARED.REQUESTED_BED_DATE),
					FIRST_ROW_COMPARED.PROBLEM, FIRST_ROW_COMPARED.TYPE_OF_BED_WARD, CONCEPT_W.DISPLAY_NAME, CONCEPT_D.DISPLAY_NAME, 
					CONCEPT_C.DISPLAY_NAME, CONCEPT_A.DISPLAY_NAME, CONCEPT_S.DISPLAY_NAME, CONCEPT_R.DISPLAY_NAME, FIRST_ROW_COMPARED.COMMENTS, 
					case when FIRST_ROW_COMPARED.CREATED_BY is null then 'System' 
						 else FIRST_ROW_COMPARED.LAST_EDIT_BY
					end,
					DATEADD (minute, 
						isnull (fac.TIMEZONE_OFFSET * 60,
								@TIME_ZONE_MINUTES_OFFSET),
						FIRST_ROW_COMPARED.[DATE]),
					FIRST_ROW_COMPARED.TRANSACTION_TYPE_CODE 
			FROM WAITING_LIST_H AS FIRST_ROW_COMPARED
					INNER JOIN #TBL_FACILITY AS FAC ON FAC.SOURCE_ID = FIRST_ROW_COMPARED.FACILITY_UID 
					LEFT JOIN #WAITING_AREA AS CONCEPT_W ON CONCEPT_W.SOURCE_ID = FIRST_ROW_COMPARED.WAITING_AREA_ID
					LEFT JOIN #FEE_DISPOSITION AS CONCEPT_D ON CONCEPT_D.SOURCE_ID = FIRST_ROW_COMPARED.FEE_DISPOSITION_ID
					LEFT JOIN #STRICT_DECISION AS CONCEPT_C ON CONCEPT_C.SOURCE_ID = FIRST_ROW_COMPARED.CONTRACT_FEE_ID
					LEFT JOIN #STRICT_DECISION AS CONCEPT_A ON CONCEPT_A.SOURCE_ID = FIRST_ROW_COMPARED.AUTHORIZED_FEE_ID
					LEFT JOIN #VISTA_SPECIALTY AS CONCEPT_S ON CONCEPT_S.SOURCE_ID = FIRST_ROW_COMPARED.SERVICE_RECEIVING_FEE_ID	
					LEFT JOIN #FEE_REASON AS CONCEPT_R ON CONCEPT_R.SOURCE_ID = FIRST_ROW_COMPARED.REASON_USING_FEE_ID
					INNER JOIN 
					(
						SELECT distinct ID, PATIENT_UID 
						FROM dbo.ACT_H  
					) A  ON  A.ID = FIRST_ROW_COMPARED.ACT_ID
						
				LEFT JOIN WAITING_LIST_H AS SECOND_ROW_COMPARED ON  SECOND_ROW_COMPARED.PK = (SELECT MAX(NEXT_ROW_COMPARED.PK)
    				FROM WAITING_LIST_H AS NEXT_ROW_COMPARED 				
    				WHERE NEXT_ROW_COMPARED.ACT_ID = FIRST_ROW_COMPARED.ACT_ID AND  
    				NEXT_ROW_COMPARED.PK < FIRST_ROW_COMPARED.PK AND
    				(NEXT_ROW_COMPARED.[DATE] >= @DATE_FROM and NEXT_ROW_COMPARED.[DATE] <= @DATE_TO))       
					AND (FIRST_ROW_COMPARED.FACILITY_UID = SECOND_ROW_COMPARED.FACILITY_UID OR (FIRST_ROW_COMPARED.FACILITY_UID IS NULL AND SECOND_ROW_COMPARED.FACILITY_UID IS NULL))
					AND (FIRST_ROW_COMPARED.REQUESTED_BED_UID = SECOND_ROW_COMPARED.REQUESTED_BED_UID OR (FIRST_ROW_COMPARED.REQUESTED_BED_UID IS NULL AND SECOND_ROW_COMPARED.REQUESTED_BED_UID IS NULL))	
					AND (FIRST_ROW_COMPARED.REQUESTED_BED_DATE = SECOND_ROW_COMPARED.REQUESTED_BED_DATE OR (FIRST_ROW_COMPARED.REQUESTED_BED_DATE IS NULL AND SECOND_ROW_COMPARED.REQUESTED_BED_DATE IS NULL))	
					AND (FIRST_ROW_COMPARED.PROBLEM = SECOND_ROW_COMPARED.PROBLEM OR (FIRST_ROW_COMPARED.PROBLEM IS NULL AND SECOND_ROW_COMPARED.PROBLEM IS NULL))
					AND (FIRST_ROW_COMPARED.TYPE_OF_BED_WARD = SECOND_ROW_COMPARED.TYPE_OF_BED_WARD OR (FIRST_ROW_COMPARED.TYPE_OF_BED_WARD IS NULL AND SECOND_ROW_COMPARED.TYPE_OF_BED_WARD IS NULL))		
					AND (FIRST_ROW_COMPARED.WAITING_AREA_ID = SECOND_ROW_COMPARED.WAITING_AREA_ID OR (FIRST_ROW_COMPARED.WAITING_AREA_ID IS NULL AND SECOND_ROW_COMPARED.WAITING_AREA_ID IS NULL))
					AND (FIRST_ROW_COMPARED.FEE_DISPOSITION_ID = SECOND_ROW_COMPARED.FEE_DISPOSITION_ID OR (FIRST_ROW_COMPARED.FEE_DISPOSITION_ID IS NULL AND SECOND_ROW_COMPARED.FEE_DISPOSITION_ID IS NULL))	  	
					AND (FIRST_ROW_COMPARED.CONTRACT_FEE_ID = SECOND_ROW_COMPARED.CONTRACT_FEE_ID OR (FIRST_ROW_COMPARED.CONTRACT_FEE_ID IS NULL AND SECOND_ROW_COMPARED.CONTRACT_FEE_ID IS NULL))	  
					AND (FIRST_ROW_COMPARED.AUTHORIZED_FEE_ID = SECOND_ROW_COMPARED.AUTHORIZED_FEE_ID OR (FIRST_ROW_COMPARED.AUTHORIZED_FEE_ID IS NULL AND SECOND_ROW_COMPARED.AUTHORIZED_FEE_ID IS NULL))	  
					AND (FIRST_ROW_COMPARED.SERVICE_RECEIVING_FEE_ID = SECOND_ROW_COMPARED.SERVICE_RECEIVING_FEE_ID OR (FIRST_ROW_COMPARED.SERVICE_RECEIVING_FEE_ID IS NULL AND SECOND_ROW_COMPARED.SERVICE_RECEIVING_FEE_ID IS NULL))	  	
					AND (FIRST_ROW_COMPARED.REASON_USING_FEE_ID = SECOND_ROW_COMPARED.REASON_USING_FEE_ID OR (FIRST_ROW_COMPARED.REASON_USING_FEE_ID IS NULL AND SECOND_ROW_COMPARED.REASON_USING_FEE_ID IS NULL))	  
					AND (FIRST_ROW_COMPARED.COMMENTS = SECOND_ROW_COMPARED.COMMENTS OR (FIRST_ROW_COMPARED.COMMENTS IS NULL AND SECOND_ROW_COMPARED.COMMENTS IS NULL))	  
			WHERE SECOND_ROW_COMPARED.PK IS NULL AND FIRST_ROW_COMPARED.[DATE] >= @DATE_FROM AND FIRST_ROW_COMPARED.[DATE] <= @DATE_TO	
			ORDER BY FIRST_ROW_COMPARED.ACT_ID, FIRST_ROW_COMPARED.PK DESC
			
			DROP TABLE #TBL_FACILITY
			DROP TABLE #WAITING_AREA
			DROP TABLE #FEE_DISPOSITION
			DROP TABLE #FEE_REASON
			DROP TABLE #STRICT_DECISION
			DROP TABLE #VISTA_SPECIALTY
			
			--GET PATIENTS INFORMATION
			CREATE TABLE #PATIENTS (PATIENT_UID UNIQUEIDENTIFIER PRIMARY KEY, PATIENT_NAME NDNS  AR(250))		
			INSERT INTO #PATIENTS(PATIENT_UID, PATIENT_NAME)
			SELECT DISTINCT PAC.PATIENT_UID, SUBSTRING(PERSON.[NAME_FAMILY], 1, 1) + SUBSTRING(s.[IDENTIFIER_EXTENSION], 7, 5)
			FROM #HISTORY_WAITING_LIST AS PAC
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = PAC.PATIENT_UID
			INNER JOIN $(varBMS_EIS).dbo.EHL7_PERSON AS PERSON ON PERSON.PFK_PERSON = ENTITY.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS S ON S.FK_ENTITY = PERSON.PFK_PERSON AND S.IDENTIFIER_ROOT = 'SSN'
			
			--GET BED INFORMATION
			CREATE TABLE #BEDS (BED_UID UNIQUEIDENTIFIER PRIMARY KEY, BED_NAME NDNS  AR(250))
			INSERT INTO #BEDS(BED_UID, BED_NAME)
			SELECT DISTINCT BED.BED_UID, PLACE.NAME
			FROM #HISTORY_WAITING_LIST AS BED
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = BED.BED_UID
			INNER JOIN $(varBMS_EIS).dbo.EHL7_PLACE AS PLACE ON PLACE.PFK_PLACE = ENTITY.PK_ENTITY
			WHERE BED.BED_UID IS NOT NULL
			
			
		SELECT H_WAITING_LIST.ACT_ID,
			CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					 CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
						ELSE H_WAITING_LIST.FACILITY_NAME		
					 END 
				 WHEN 'I' THEN 	H_WAITING_LIST.FACILITY_NAME
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FACILITY_NAME = H_WAITING_LIST.FACILITY_NAME THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FACILITY_NAME IS NOT NULL AND H_WAITING_LIST.FACILITY_NAME IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE H_WAITING_LIST.FACILITY_NAME		
					END 
			 END AS FACILITY,	 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE PATIENT.PATIENT_NAME		
					END 
				 WHEN 'I' THEN 	PATIENT.PATIENT_NAME
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.PATIENT_UID = H_WAITING_LIST.PATIENT_UID THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.PATIENT_UID IS NOT NULL AND H_WAITING_LIST.PATIENT_UID IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE PATIENT.PATIENT_NAME		
					END 
			 END AS PATIENT_NAME,
			 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE BED.BED_NAME		
					END 
				 WHEN 'I' THEN 	BED.BED_NAME
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.BED_UID = H_WAITING_LIST.BED_UID THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.BED_UID IS NOT NULL AND H_WAITING_LIST.BED_UID IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE BED.BED_NAME		
					END 
			 END AS BED,
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,101)+ ' '+convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,108)+ ' ' +right(convert(varchar(30),H_WAITING_LIST.REQ_BED_DATE,109),2) 
					END 
				 WHEN 'I' THEN convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,101)+ ' '+convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,108)+ ' ' +right(convert(varchar(30),H_WAITING_LIST.REQ_BED_DATE,109),2) 
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REQ_BED_DATE = H_WAITING_LIST.REQ_BED_DATE THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REQ_BED_DATE IS NOT NULL AND H_WAITING_LIST.REQ_BED_DATE IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE   convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,101)+ ' '+convert(varchar(20),H_WAITING_LIST.REQ_BED_DATE,108)+ ' ' +right(convert(varchar(30),H_WAITING_LIST.REQ_BED_DATE,109),2) 		
					END 
			 END AS REQ_BED_DATE,
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.PROBLEM
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.PROBLEM
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.PROBLEM = H_WAITING_LIST.PROBLEM THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.PROBLEM IS NOT NULL AND H_WAITING_LIST.PROBLEM IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.PROBLEM		
					END 
			 END AS PROBLEM,
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.TYPE_OF_BED_WARD
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.TYPE_OF_BED_WARD
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD = H_WAITING_LIST.TYPE_OF_BED_WARD THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD IS NOT NULL AND H_WAITING_LIST.TYPE_OF_BED_WARD IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.TYPE_OF_BED_WARD		
					END 
			 END AS TYPE_OF_BED_WARD,
			 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.WAITING_AREA
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.WAITING_AREA
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.WAITING_AREA = H_WAITING_LIST.WAITING_AREA THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.WAITING_AREA IS NOT NULL AND H_WAITING_LIST.WAITING_AREA IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.WAITING_AREA		
					END 
			 END AS WAITING_AREA,	 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.FEE_DISPOSITION
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.FEE_DISPOSITION
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FEE_DISPOSITION = H_WAITING_LIST.FEE_DISPOSITION THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FEE_DISPOSITION IS NOT NULL AND H_WAITING_LIST.FEE_DISPOSITION IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.FEE_DISPOSITION		
					END 
			 END AS FEE_DISPOSITION, 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.CONTRACT_FEE
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.CONTRACT_FEE
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.CONTRACT_FEE = H_WAITING_LIST.CONTRACT_FEE THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.CONTRACT_FEE IS NOT NULL AND H_WAITING_LIST.CONTRACT_FEE IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.CONTRACT_FEE		
					END 
			 END AS CONTRACT_FEE,
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.AUTH_FEE
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.AUTH_FEE
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.AUTH_FEE = H_WAITING_LIST.AUTH_FEE THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.AUTH_FEE IS NOT NULL AND H_WAITING_LIST.AUTH_FEE IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.AUTH_FEE		
					END 
			 END AS AUTH_FEE, 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.SERV_REC
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.SERV_REC
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.SERV_REC = H_WAITING_LIST.SERV_REC THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.SERV_REC IS NOT NULL AND H_WAITING_LIST.SERV_REC IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.SERV_REC		
					END 
			 END AS SERV_REC,
			 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.REASON
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.REASON
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REASON = H_WAITING_LIST.REASON THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REASON IS NOT NULL AND H_WAITING_LIST.REASON IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.REASON		
					END 
			 END AS REASON, 
			 CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE
				 WHEN 'D' THEN 
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL THEN ''
					ELSE  H_WAITING_LIST.COMMENTS
					END 
				 WHEN 'I' THEN 	H_WAITING_LIST.COMMENTS
				 WHEN 'U' THEN
					CASE WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS = H_WAITING_LIST.COMMENTS THEN ''
						 WHEN PREVIOUS_H_WAITING_LIST.PK IS NOT NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS IS NOT NULL AND H_WAITING_LIST.COMMENTS IS NULL THEN 'DELETED PREVIOUS INFORMATION'
						 ELSE  H_WAITING_LIST.COMMENTS		
					END 
			 END AS COMMENTS,
			 CASE WHEN H_WAITING_LIST.CREATED_BY IS NULL THEN 'SYSTEM' 
						 ELSE  H_WAITING_LIST.CREATED_BY
					END AS CREATED_BY,
			 H_WAITING_LIST.DATE_FAC AS DATE_FAC,
			CASE H_WAITING_LIST.TRANSACTION_TYPE_CODE WHEN 'I' THEN 'Inserted'
					WHEN 'U' THEN 'Updated' WHEN 'D' THEN 'Deleted' END AS EVENT_TYPE
		FROM #HISTORY_WAITING_LIST AS H_WAITING_LIST
		LEFT JOIN #HISTORY_WAITING_LIST AS PREVIOUS_H_WAITING_LIST ON PREVIOUS_H_WAITING_LIST.PK = (SELECT MAX(PK) FROM #HISTORY_WAITING_LIST WHERE ACT_ID = H_WAITING_LIST.ACT_ID AND PK < H_WAITING_LIST.PK)
		LEFT JOIN #BEDS AS BED ON BED.BED_UID = H_WAITING_LIST.BED_UID
		LEFT JOIN #PATIENTS AS PATIENT ON PATIENT.PATIENT_UID = H_WAITING_LIST.PATIENT_UID
		ORDER BY  H_WAITING_LIST.FACILITY_NAME, H_WAITING_LIST.ACT_ID,  H_WAITING_LIST.DATE_FAC 
 
		DROP TABLE #HISTORY_WAITING_LIST
		DROP TABLE #PATIENTS
		DROP TABLE #BEDS
			
		END
	END
	
END	

GO