IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Rpt_StaffAssignment]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Rpt_StaffAssignment]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_Rpt_StaffAssignment]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NDNS  AR(500),
	@FACILITIES_IDS NDNS  AR(MAX) = '',
	@REPORT_TYPE NDNS  AR(50)
AS
BEGIN

	SET NOCOUNT ON;
	
	IF (@REPORT_TYPE = 'STAFF')
	BEGIN
		
		IF @DATE_FROM > @DATE_TO
			RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
		ELSE
		BEGIN
			set @DATE_FROM = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_FROM );
			set @DATE_TO = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @DATE_TO );

			--GET INFORMATION ABOUT SELECTED FACILITIES
			CREATE TABLE #TBL_FACILITY (SOURCE_ID NDNS  AR(250) PRIMARY KEY,  TIMEZONE_OFFSET INT)
			INSERT INTO #TBL_FACILITY(SOURCE_ID, TIMEZONE_OFFSET) 
			SELECT DISTINCT CONVERT(NDNS  AR(250), FACILITY.VALUE), [dbo].[ufn_GetOffsetByFacilityUID](VALUE) 
			FROM dbo.ufn_Split(@FACILITIES_IDS, ',') AS FACILITY
	
			CREATE TABLE #BED_STAFF
			(
				BED_UID UNIQUEIDENTIFIER NULL,
				PATIENT_UID UNIQUEIDENTIFIER NULL,
				STAFF NDNS  AR(250) NULL,
				[DATE] DATETIME NULL,
				CREATED_BY NDNS  AR(50),
				EVENT_TYPE NDNS  AR(100)
			 )
			 INSERT INTO #BED_STAFF(BED_UID, PATIENT_UID, STAFF, [DATE], CREATED_BY, EVENT_TYPE)
			 SELECT STAFF.BED_UID, STAFF.PATIENT_UID, STAFF.STAFF, 
				  	DATEADD (minute, 
					ISNULL(FACILITY.TIMEZONE_OFFSET * 60,
							@TIME_ZONE_MINUTES_OFFSET), STAFF.[DATE]),
					CASE WHEN STAFF.CREATED_BY IS NULL THEN 'SYSTEM' 
						 ELSE [DBO].[UFN_GETUSERNAMEBYSID](STAFF.CREATED_BY)
					END ,
					CASE STAFF.TRANSACTION_TYPE_CODE WHEN 'I' THEN 'Inserted'
					WHEN 'U' THEN 'Updated' WHEN 'D' THEN 'Deleted' END
			 FROM dbo.BED_STAFF_H AS STAFF
			 INNER JOIN #TBL_FACILITY AS FACILITY ON FACILITY.SOURCE_ID = STAFF.FACILITY_UID 
			 WHERE STAFF.[DATE] >= @DATE_FROM and STAFF.[DATE] <= @DATE_TO
			
			 DROP TABLE #TBL_FACILITY
			 
			CREATE TABLE #PATIENTS (PATIENT_UID UNIQUEIDENTIFIER PRIMARY KEY, PATIENT_NAME NDNS  AR(250))
			INSERT INTO #PATIENTS(PATIENT_UID, PATIENT_NAME)
			SELECT DISTINCT PAC.PATIENT_UID, SUBSTRING(PERSON.[NAME_FAMILY], 1, 1) + SUBSTRING(s.[IDENTIFIER_EXTENSION], 7, 5)
			FROM #BED_STAFF AS PAC
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = PAC.PATIENT_UID
			INNER JOIN $(varBMS_EIS).dbo.EHL7_PERSON AS PERSON ON PERSON.PFK_PERSON = ENTITY.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS S ON S.FK_ENTITY = PERSON.PFK_PERSON AND S.IDENTIFIER_ROOT = 'SSN'
			
			CREATE TABLE #BEDS (BED_UID UNIQUEIDENTIFIER, BED_NAME NDNS  AR(250), DIVISION_NAME NDNS  AR(MAX))
			INSERT INTO #BEDS(BED_UID, BED_NAME, DIVISION_NAME)
			SELECT DISTINCT  E.IDENTIFIER, BED.NAME, WARD_GROUP.NAME
			FROM $(varBMS_EIS).[dbo].[EHL7_PLACE] AS BED
			INNER JOIN $(varBMS_EIS).[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
			INNER JOIN #BED_STAFF AS BED_STAFF ON BED_STAFF.BED_UID = E.IDENTIFIER
			INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
			INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ORGANIZATION]AS WARD_GROUP ON WARD_GROUP.PFK_ORGANIZATION = R_BED.FK_SCOPER_ENTITY
			WHERE BED.CODE_DISPLAY_NAME ='BED' AND E.IDENTIFIER IN (SELECT DISTINCT BED_UID FROM #BED_STAFF AS BED)
			
			;WITH SET_BED_ASSOCIATION_TO_MULTIPLE_DIVISION AS
			(
					SELECT A.BED_UID, STUFF((SELECT DISTINCT ',' +  DIVISION_NAME
							   FROM #BEDS
							   WHERE BED_UID = A.BED_UID
							   FOR XML PATH('')), 1, 1, '') AS DIVISIONS 
							   
					FROM (
					SELECT BED_UID
					FROM #BEDS
					GROUP BY BED_UID
					HAVING COUNT(BED_UID) > 1 ) A 
			)
			
			UPDATE B
				SET B.DIVISION_NAME = G_BED_WARD.DIVISIONS
			FROM #BEDS B
			INNER JOIN SET_BED_ASSOCIATION_TO_MULTIPLE_DIVISION AS G_BED_WARD ON G_BED_WARD.BED_UID = B.BED_UID
			
			;WITH BED_ASSOCIATION_TO_MULTIPLE_DIVISION AS
			(
				SELECT BED_UID, BED_NAME, DIVISION_NAME
				FROM #BEDS 
				GROUP BY BED_UID, BED_NAME, DIVISION_NAME 
			)
			
			SELECT CAST(BED_STAFF.BED_UID as nvarchar(50)) as BED_UID,
			BED.DIVISION_NAME AS DIVISION, 
			BED.BED_NAME AS BED, 
			BED_STAFF.STAFF,
			PATIENT.PATIENT_NAME AS PATIENT,
			BED_STAFF.CREATED_BY,
			BED_STAFF.[DATE] as [DATE],
			BED_STAFF.EVENT_TYPE AS EVENT_TYPE   
			FROM #BED_STAFF AS BED_STAFF
			LEFT JOIN #PATIENTS AS PATIENT ON PATIENT.PATIENT_UID = BED_STAFF.PATIENT_UID
			LEFT JOIN BED_ASSOCIATION_TO_MULTIPLE_DIVISION AS BED ON BED.BED_UID= BED_STAFF.BED_UID
			ORDER BY BED.DIVISION_NAME, BED.BED_NAME, BED_STAFF.[DATE]
			DROP TABLE #BEDS
			DROP TABLE #PATIENTS
			DROP TABLE #BED_STAFF
			
		END
		
	END
	
END

GO