CREATE TABLE [dbo].[DIVERSION_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ID] [int] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[ACTIVE] [bit] NOT NULL,
	[START_DATE] [datetime] NOT NULL,
	[END_DATE] [datetime] NOT NULL,
	[LOCATION_ID] [int] NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[COMMENTS] [nvarchar](max) NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL,
	[ENTERED_BY] [nvarchar](50) NOT NULL,
	[ENTERED_DATE] [datetime] NOT NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[DIVERSION_H] ADD CONSTRAINT [PK_DIVERSION_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'PK'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity number and primary key of transaction table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Which facility this diversion applies to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Wheter the diversion is active (current) or not.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'ACTIVE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Start date the diversion is valid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'START_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Till what date the diversion is valid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'END_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The location to which the diversion applies.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'LOCATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Additional diversion comments will be stored here.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code of transaction(I = Inserted, U = Updated, D = Deleted).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'TRANSACTION_TYPE_CODE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'CREATED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user name of the BMS application user who entered a diversion.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DateTime when BMS user enters a diversion.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'ENTERED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user name of the BMS application who changed a diversion.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table storing information about diversion.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION_H'
GO


