CREATE TABLE [dbo].[DISCHARGE_REQ_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [NVARCHAR] (50) NOT NULL,
[IEN] [VARCHAR](50) NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ORDERED_DATE] [DATETIME] NOT NULL,
[IS_ACTIVE] [BIT] NOT NULL,
[SIGNED_BY_UID] [UNIQUEIDENTIFIER] NULL,
[SIGNED_DATE] [datetime] NULL,
[RELEASED_DATE] [datetime] NULL,
[SCHEDULER_UID] [UNIQUEIDENTIFIER] NULL,
[PROVIDER_UID] [UNIQUEIDENTIFIER] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[HOSPITAL_LOCATION_UID] [UNIQUEIDENTIFIER] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[ORDER_TEXT] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ORDERABLE_ITEM_ID] [int] NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[DISCHARGE_REQ_H] ADD CONSTRAINT [PK_DISCHARGE_REQ_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table which stores discharge requests data of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'ORDER_TEXT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the discharge request was released.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'RELEASED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the person who scheduled the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'SCHEDULER_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The person who signed the document.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'SIGNED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the discharge request document was signed.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'SIGNED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The hospital location id (EIS organization reference).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'HOSPITAL_LOCATION_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Ordered date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'ORDERED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If order is active.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'IS_ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indentity column imported from VistA(VistA IEN)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'IEN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The ward id where the patient is admitted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'UID of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_REQ_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the order was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_REQ_H', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO