IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_Incremental_UpdateDimIconFlagFacility]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_Incremental_UpdateDimIconFlagFacility]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_ETL_Incremental_UpdateDimIconFlagFacility]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN
SET NOCOUNT ON;

BEGIN TRY
	
	DECLARE @SQL VARCHAR(max), @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT, @START_DATE DATETIME
	--TRUNCATE TABLE DIM_ICON_FLAG_FACILITY_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_FACILITY_ETL]'))
	BEGIN
		TRUNCATE TABLE DIM_ICON_FLAG_FACILITY_ETL
	END

	SELECT @START_DATE = ISNULL(max(_ssis_timestamp), '1900-01-01') FROM DIM_ICON_FLAG_FACILITY
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)		
	
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Dim_Icon_Flag_Facility](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Dim_Icon_Flag_Facility](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''') '')'
		
	SET @SQL = ''
	SET @SQL = @SQL +
		'INSERT INTO DIM_ICON_FLAG_FACILITY_ETL([ICON_FLAG_ID], [FACILITY_UID], [ORDER_INDEX], [ACTIVE], [PATIENT_OR_ROOMBED], [ICON_NAME]
			   ,[DESCRIPTION], [COMMENT], [MOUSE_OVER_TEXT], [ENTERED_BY], [ENTERED_DATE], [LAST_EDIT_BY], [LAST_EDIT_DATE]
			   ,[SOURCE_ID], [_SSIS_TIMESTAMP])
		 SELECT [ICON_FLAG_ID], [FACILITY_UID], [ORDER_INDEX], [ACTIVE], [PATIENT_OR_ROOMBED], [ICON_NAME], [DESCRIPTION], [COMMENT]
			   ,[MOUSE_OVER_TEXT], [ENTERED_BY], [ENTERED_DATE], [LAST_EDIT_BY], [LAST_EDIT_DATE], [SOURCE_ID], [_SSIS_TIMESTAMP]
		FROM ' + @FROM_CLAUSE
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	
	IF @ROWS <> 0
	BEGIN
			--ADDED INDEXES ON TABLE DIM_ICON_FLAG_FACILITY_ETL	
			UPDATE tbl
				SET [DIM_ICON_FLAG_ID] = dif.ID
				,[DIM_ORGANIZATION_FACILITY_ID] = FACILITY.ID
				,[ORDER_INDEX] = u.[ORDER_INDEX]
				,[ACTIVE] = u.[ACTIVE]
				,[PATIENT_OR_ROOMBED] = u.[PATIENT_OR_ROOMBED]
				,[ICON_NAME] = u.[ICON_NAME]
				,[DESCRIPTION] = u.[DESCRIPTION]
				,[COMMENT] = u.[COMMENT]
				,[MOUSE_OVER_TEXT] = u.[MOUSE_OVER_TEXT]
				,[ENTERED_BY] = u.[ENTERED_BY]
				,[ENTERED_DATE] = u.[ENTERED_DATE]
				,[LAST_EDIT_BY] = u.[LAST_EDIT_BY]
				,[LAST_EDIT_DATE] = u.[LAST_EDIT_DATE]
				,[SOURCE_ID] = u.[SOURCE_ID]
				,[_SSIS_TIMESTAMP] = u.[_SSIS_TIMESTAMP]
			FROM dbo.DIM_ICON_FLAG_FACILITY tbl
			INNER JOIN DIM_ICON_FLAG_FACILITY_ETL u ON tbl.SOURCE_ID = u.SOURCE_ID
			LEFT JOIN DIM_ICON_FLAG dif ON dif.source_id = u.[ICON_FLAG_ID]
			LEFT JOIN DIM_ORGANIZATION FACILITY ON FACILITY.SOURCE_ID = u.[FACILITY_UID]

			INSERT INTO [DIM_ICON_FLAG_FACILITY]
				([DIM_ICON_FLAG_ID]
				,[DIM_ORGANIZATION_FACILITY_ID]
				,[ORDER_INDEX]
				,[ACTIVE]
				,[PATIENT_OR_ROOMBED]
				,[ICON_NAME]
				,[DESCRIPTION]
				,[COMMENT]
				,[MOUSE_OVER_TEXT]
				,[ENTERED_BY]
				,[ENTERED_DATE]
				,[LAST_EDIT_BY]
				,[LAST_EDIT_DATE]
				,[SOURCE_ID]
				,[_SSIS_TIMESTAMP])
			SELECT dif.ID
				,FACILITY.ID
				,diffu.[ORDER_INDEX]
				,diffu.[ACTIVE]
				,diffu.[PATIENT_OR_ROOMBED]
				,diffu.[ICON_NAME]
				,[DESCRIPTION]
				,diffu.[COMMENT]
				,diffu.[MOUSE_OVER_TEXT]
				,diffu.[ENTERED_BY]
				,diffu.[ENTERED_DATE]
				,diffu.[LAST_EDIT_BY]
				,diffu.[LAST_EDIT_DATE]
				,diffu.[SOURCE_ID]
				,diffu.[_SSIS_TIMESTAMP]
			FROM DIM_ICON_FLAG_FACILITY_ETL  diffu 
			LEFT JOIN [DIM_ICON_FLAG] dif ON dif.source_id = diffu.[ICON_FLAG_ID]
			LEFT JOIN DIM_ORGANIZATION FACILITY ON FACILITY.SOURCE_ID = diffu.[FACILITY_UID]
			WHERE NOT EXISTS (SELECT 1 FROM DIM_ICON_FLAG_FACILITY WHERE SOURCE_ID = diffu.SOURCE_ID)
	END
	
	RETURN @ROWS
	
END TRY
BEGIN CATCH
	DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
			
	SELECT @ErrorMessage = '*** ERROR in usp_ETL_Incremental_UpdateDimIconFlagFacility: ' + ERROR_MESSAGE(),
		   @ErrorSeverity = ERROR_SEVERITY(),
		   @ErrorState = ERROR_STATE();
	
	RAISERROR (@ErrorMessage,  @ErrorSeverity, @ErrorState) WITH LOG;
END CATCH	

END

GO


