IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_DISCHARGE_ID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GET_DISCHARGE_ID]
GO

CREATE FUNCTION [dbo].[GET_DISCHARGE_ID] 
(
	@PATIENT_ID INT,
	@WARD_ID INT,
	@VISTA_SITE_ID INT,
	@IEN VARCHAR(250)
)
RETURNS INT
AS
BEGIN
	
	DECLARE @DIS_ID INT, @DIS_IEN BIGINT
	
	SELECT @DIS_IEN = MAX(CAST(IEN as BIGINT))
	FROM  dbo.FACT_DISCHARGE_EVN  
    WHERE VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID  AND  
			DIM_WARD_ID = @WARD_ID AND DIM_PATIENT_ID = @PATIENT_ID 
			AND CAST(IEN AS BIGINT) > CAST(@IEN AS BIGINT)
		
   SELECT @DIS_ID = ID 
   FROM dbo.FACT_DISCHARGE_EVN
   WHERE IEN = CAST(@DIS_IEN AS VARCHAR(250)) AND VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID
					   
	RETURN @DIS_ID

END

GO


