IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_ADMISSION_ID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GET_ADMISSION_ID]
GO

/****** Object:  UserDefinedFunction [dbo].[GET_ADMISSION_ID]    Script Date: 10/28/2012 14:30:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GET_ADMISSION_ID] 
(
	@PATIENT_ID INT,
	@WARD_ID INT,
	@VISTA_SITE_ID INT,
	@IEN VARCHAR(250)
)
RETURNS INT
AS
BEGIN
	
	DECLARE @ADM_ID INT, @ADM_IEN BIGINT
	
	SELECT @ADM_IEN = MAX(CAST(IEN as BIGINT))
	FROM  dbo.FACT_ADMISSION_EVN
    WHERE VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID  AND  
			DIM_WARD_ID = @WARD_ID AND DIM_PATIENT_ID = @PATIENT_ID 
			AND CAST(IEN AS BIGINT) = CAST(@IEN AS BIGINT)
		
   SELECT @ADM_ID = ID 
   FROM dbo.FACT_ADMISSION_EVN
   WHERE IEN = CAST(@ADM_IEN AS VARCHAR(250)) AND VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID
					   
	RETURN @ADM_ID

END


GO


