
CREATE TABLE [dbo].[GROUP_ICON_ASSOCIATION](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[DIM_BED_ID] [int] NULL,
	[DIM_PATIENT_ID] [int] NULL,
	[DIM_ICON_FLAG_ID] [int] NULL,
	[DIM_ICON_FLAG_FACILITY_ID] [int] NULL,
	[SOURCE_ID] INT NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
 CONSTRAINT [PK_GROUP_ICON_ASSOCIATION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION]  WITH NOCHECK ADD  CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_BED] FOREIGN KEY([DIM_BED_ID])
REFERENCES [dbo].[DIM_BED] ([ID])
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION] CHECK CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_BED]
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION]  WITH NOCHECK ADD  CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_ICON_FLAG] FOREIGN KEY([DIM_ICON_FLAG_ID])
REFERENCES [dbo].[DIM_ICON_FLAG] ([ID])
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION] CHECK CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_ICON_FLAG]
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION]  WITH NOCHECK ADD  CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_ICON_FLAG_FACILITY] FOREIGN KEY([DIM_ICON_FLAG_FACILITY_ID])
REFERENCES [dbo].[DIM_ICON_FLAG_FACILITY] ([ID])
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION] CHECK CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_ICON_FLAG_FACILITY]
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION]  WITH NOCHECK ADD  CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_PATIENT] FOREIGN KEY([DIM_PATIENT_ID])
REFERENCES [dbo].[DIM_PATIENT] ([ID])
GO

ALTER TABLE [dbo].[GROUP_ICON_ASSOCIATION] CHECK CONSTRAINT [FK_GROUP_ICON_ASSOCIATION_DIM_PATIENT]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'DIM_BED_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'DIM_PATIENT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Icon id from the icon definition table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'DIM_ICON_FLAG_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Icon id from the icon facility table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'DIM_ICON_FLAG_FACILITY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the record from the BMS source table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'SOURCE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'_SSIS_TIMESTAMP'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that associates icons with their corresponding bed or patient id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION'
GO

CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON GROUP_ICON_ASSOCIATION(SOURCE_ID ASC)
GO