CREATE TABLE [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL](
	[CREATION_DATE] [datetime] NULL,
	[DIM_UNAVAILABLE_REASON_CODE] [varchar](100) NULL,
	[DIM_BED_ID] [nvarchar](250) NULL,
	[DIVISION_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[CREATIONBY] [nvarchar](250) NULL,
	[EDITEDBY] [nvarchar](250) NULL,
	[COMPLETEDBY] [nvarchar](250) NULL,
	[EDITED_DATE] [datetime] NULL,
	[COMPLETED_DATE] [datetime] NULL,
	[COMMENT] [nvarchar](max) NULL,
	[EXPECTED_COMPLETED_DATE] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table storing temporary history information about beds unavailable from bms database.  Mapped with BMS_BED_REASON_COMMENT_HISTORY table from the BMS database. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_BED_UNAVAILABLE_HISTORY_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_BED_ID] ON [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL] 
(
	[DIM_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_UNAVAILABLE_REASON_CODE] ON [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL] 
(
	[DIM_UNAVAILABLE_REASON_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIVISION_DIM_ORGANIZATION_ID] ON [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL] 
(
	[DIVISION_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_BED_UNAVAILABLE_HISTORY_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO