
CREATE TABLE [dbo].[DIM_MEDICAL_DIVISION](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](100) NOT NULL,
	[CODE_SYSTEM] [varchar](100) NOT NULL,
	[CODE_SYSTEM_NAME] [varchar](100) NOT NULL,
	[DISPLAY_NAME] [nvarchar](250) NOT NULL,
	[SOURCE_ID] [nvarchar](250) NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
 CONSTRAINT [PK_DIM_MEDICAL_DIVISION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table''s identifier.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medical division vocabulary''s code.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'CODE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Vocabulary''s code system.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'CODE_SYSTEM'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Vocabulary''s code system name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'CODE_SYSTEM_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Vocabulary''s display name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'DISPLAY_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id or ids from the source table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'SOURCE_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table containing medical division vocabulary''s values.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The column contains the latest date and time that the record has been updated.', @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_MEDICAL_DIVISION', @level2type=N'COLUMN',@level2name=N'_SSIS_TIMESTAMP'
GO
CREATE NONCLUSTERED INDEX [idx_CODE] ON DIM_MEDICAL_DIVISION(CODE ASC)
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[DIM_MEDICAL_DIVISION] (SOURCE_ID ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO