-- Columns

CREATE TABLE [dbo].[JOB_AUDIT_PARAM]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[JOB_AUDIT_ID] [int] NOT NULL,
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VALUE] [nvarchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[JOB_AUDIT_PARAM] ADD CONSTRAINT [PK_JOB_AUDIT_PARAM] PRIMARY KEY CLUSTERED  ([ID])
GO

CREATE NONCLUSTERED INDEX [IDX_JOB_AUDIT_ID] ON [dbo].[JOB_AUDIT_PARAM] 
(
	  [JOB_AUDIT_ID] ASC
)
INCLUDE ([ID], [NAME], [VALUE])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

-- Foreign Keys

ALTER TABLE [dbo].[JOB_AUDIT_PARAM] ADD CONSTRAINT [FK_JOB_AUDIT_PARAM_JOB_AUDIT] FOREIGN KEY ([JOB_AUDIT_ID]) REFERENCES [dbo].[JOB_AUDIT] ([ID])
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT_PARAM', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the audit job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT_PARAM', @level2type=N'COLUMN',@level2name=N'JOB_AUDIT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The start datetime or end datetime text of the data logging.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT_PARAM', @level2type=N'COLUMN',@level2name=N'NAME'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The start datetime or end datetime value of the data logging.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT_PARAM', @level2type=N'COLUMN',@level2name=N'VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores the start datetime and the end datetime of a VistA Integration scheduler execution.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT_PARAM'
GO