-- Columns

CREATE TABLE [dbo].[JOB_AUDIT]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[VISTA_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTA_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[RETRIEVAL_METHOD] [tinyint] NOT NULL,
[RETRIEVED_DATA_TYPE] [smallint] NOT NULL,
[RETRIEVED_ENTRIES_NUMBER] [int] NOT NULL,
[START_DATE] [datetime] NOT NULL,
[END_DATE] [datetime] NULL,
[LAUNCH_TYPE] [tinyint] NOT NULL,
[STATUS] [tinyint] NOT NULL,
[ERROR_MESSAGE] [nvarchar] (4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DETAILS] [nvarchar] (MAX) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[JOB_AUDIT] ADD CONSTRAINT [PK_JOB_AUDIT] PRIMARY KEY CLUSTERED  ([ID])
GO

CREATE NONCLUSTERED INDEX [IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID_DATES] ON [dbo].[JOB_AUDIT] 
(
      [VISTA_ID] ASC,
      [RETRIEVAL_METHOD] ASC,
      [RETRIEVED_DATA_TYPE] ASC,
      [STATUS] ASC,
      [START_DATE] ASC,
      [END_DATE] ASC
)
INCLUDE ([ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID] ON [dbo].[JOB_AUDIT] 
(
	  [VISTA_ID] ASC,
      [RETRIEVAL_METHOD] ASC,
      [RETRIEVED_DATA_TYPE] ASC,
      [STATUS] ASC
)
INCLUDE ([ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_VISTA_ID_STATUS] ON [dbo].[JOB_AUDIT] 
(
	[VISTA_ID] ASC,
	[STATUS] ASC
)
INCLUDE ( [END_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'VISTA_NAME'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'VISTA_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Column that stores the method used to connect to VistA Integration (madows, cache or hl7).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'RETRIEVAL_METHOD'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Column that contains the type of the retrieved data (bed, ward, etc).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'RETRIEVED_DATA_TYPE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The number of processed records.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'RETRIEVED_ENTRIES_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The data processing start datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'START_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The data processing end datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'END_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The way that the audit process was launched: manual or authomatic.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'LAUNCH_TYPE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The status of a VistA Integration operation execution (succeeded, failed, running or partially succeeded).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'STATUS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The error message text.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'ERROR_MESSAGE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Data processing details.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT', @level2type=N'COLUMN',@level2name=N'DETAILS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores operations log from VistA.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'JOB_AUDIT'
GO
