CREATE TABLE [dbo].[ACTION_ALL]
(
[ID] [uniqueidentifier] NOT NULL,
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PARENT] [uniqueidentifier] NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_All_AfterDelete] 
   ON  [dbo].[ACTION_ALL] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Action_All_H]
			   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, PARENT, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_All_AfterInsert] 
   ON  [dbo].[ACTION_ALL] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Action_All_H]
			   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, PARENT, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_All_AfterUpdate] 
   ON  [dbo].[ACTION_ALL] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Action_All_H]
			   (ID, NAME, PARENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, PARENT, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Action_All_InsteadOfInsert] 
   ON  [dbo].[ACTION_ALL]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
       INSERT INTO [dbo].[Action_All]
			   (ID, NAME, PARENT, CREATED, CREATEDBY)
			SELECT ID, NAME, PARENT, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;

	ELSE
		INSERT INTO [dbo].[Action_All]
			   (ID, NAME, PARENT)
			SELECT ID, NAME, PARENT
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Action_All_InsteadOfUpdate] 
   ON  [dbo].[ACTION_ALL] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	    UPDATE [dbo].[Action_All]
		SET NAME = inserted.NAME,
			PARENT = inserted.PARENT,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Action_All]
		INNER JOIN inserted ON inserted.id = [dbo].[Action_All].id;

	 ELSE
	    UPDATE [dbo].[Action_All]
		SET NAME = inserted.NAME,
			PARENT = inserted.PARENT
		FROM [dbo].[Action_All]
		INNER JOIN inserted ON inserted.id = [dbo].[Action_All].id;

END
GO

--Constraints
ALTER TABLE [dbo].[ACTION_ALL] ADD CONSTRAINT [PK_ACTION_ALL] PRIMARY KEY CLUSTERED  ([ID], [PARENT]) ON [PRIMARY]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_PARENT] ON [dbo].[ACTION_ALL] 
(
	[PARENT] ASC
)
INCLUDE ( [NAME]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates an action with its parent action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table''s identifier.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the parent action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'PARENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL', 'COLUMN', N'UPDATEDBY'
GO
