CREATE TABLE [dbo].[ADMISSION_REQ]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [NVARCHAR] (50) NOT NULL,
[IEN] [VARCHAR](50) NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ORDERED_DATE] [DATETIME] NOT NULL,
[IS_ACTIVE] [BIT] NOT NULL CONSTRAINT [DF_ADMISSION_REQ_IS_ACTIVE] DEFAULT ((1)),
[SIGNED_BY_UID] [UNIQUEIDENTIFIER] NULL,
[SIGNED_DATE] [datetime] NULL,
[RELEASED_DATE] [datetime] NULL,
[PROVIDER_UID] [UNIQUEIDENTIFIER] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[HOSPITAL_LOCATION_UID] [UNIQUEIDENTIFIER] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[ORDER_TEXT] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__ADMISSION___ssis__186C9245] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL )
GO

SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[ADMISSION_REQ_tgg_ssis_delete] on dbo.ADMISSION_REQ after delete as begin  delete [dbo].[ADMISSION_REQ_ssisdel] from [deleted] _xyz where [dbo].[ADMISSION_REQ_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ADMISSION_REQ_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[ADMISSION_REQ_tgg_ssis_insert] on dbo.ADMISSION_REQ after insert as begin delete [dbo].[ADMISSION_REQ_ssisdel]  from [inserted] _xyz where [dbo].[ADMISSION_REQ_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Req_AfterDelete] 
   ON  [dbo].[ADMISSION_REQ] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Req_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM deleted;

END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Req_AfterInsert] 
   ON  [dbo].[ADMISSION_REQ] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Req_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted; 
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Req_AfterUpdate] 
   ON  [dbo].[ADMISSION_REQ] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Req_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()				
		FROM inserted;	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Req_InsteadOfInsert] 
   ON  [dbo].[ADMISSION_REQ]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[Admission_Req]
				(DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT	 DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, _ssis_timestamp, GETUTCDATE(),  
				dbo.ufn_Get_BMS_User_Name()
			FROM inserted;

	ELSE
		INSERT INTO [dbo].[ADMISSION_REQ] 
				(DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, _ssis_timestamp)
		SELECT	 DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT, CREATION_UTC_DATE, _ssis_timestamp
			FROM inserted;

END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Req_InsteadOfUpdate] 
   ON  [dbo].[ADMISSION_REQ] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 UPDATE [dbo].[ADMISSION_REQ] 
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ORDERED_DATE = inserted.ORDERED_DATE, 
			IS_ACTIVE = inserted.IS_ACTIVE, 
			SIGNED_BY_UID = inserted.SIGNED_BY_UID,
			SIGNED_DATE = inserted.SIGNED_DATE,
			RELEASED_DATE = inserted.RELEASED_DATE,
			PROVIDER_UID = inserted.PROVIDER_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID,
			WARD_UID = inserted.WARD_UID, 
			ORDER_TEXT = inserted.ORDER_TEXT,
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
		    _ssis_timestamp = current_timestamp,																
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[ADMISSION_REQ] 
			INNER JOIN inserted ON inserted.ID = [dbo].[ADMISSION_REQ].ID;
	 ELSE
	    UPDATE [dbo].[ADMISSION_REQ] 
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ORDERED_DATE = inserted.ORDERED_DATE, 
			IS_ACTIVE = inserted.IS_ACTIVE, 
			SIGNED_BY_UID = inserted.SIGNED_BY_UID,
			SIGNED_DATE = inserted.SIGNED_DATE,
			RELEASED_DATE = inserted.RELEASED_DATE,
			PROVIDER_UID = inserted.PROVIDER_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID,
			WARD_UID = inserted.WARD_UID, 
			ORDER_TEXT = inserted.ORDER_TEXT,
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
			_ssis_timestamp = current_timestamp
		FROM [dbo].[ADMISSION_REQ] 
			INNER JOIN inserted ON inserted.ID = [dbo].[ADMISSION_REQ].ID;
END
GO

--Constraints
ALTER TABLE [dbo].[ADMISSION_REQ] ADD CONSTRAINT [PK_ADMISSION_REQ] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[ADMISSION_REQ] ADD CONSTRAINT [DF_ADMISSION_REQ_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO

--Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[ADMISSION_REQ] ([_ssis_timestamp])
GO
CREATE NONCLUSTERED INDEX [IDX_ID_VISTA_SITE_UID] ON [dbo].[ADMISSION_REQ] 
(
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[ADMISSION_REQ] 
(
	[RELEASED_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ( [ID]) 
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE] ON [dbo].[ADMISSION_REQ] 
([IS_ACTIVE], [VISTA_SITE_UID],[ORDERED_DATE])
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID])
GO

CREATE INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID] ON [dbo].[ADMISSION_REQ] 
([IS_ACTIVE], [VISTA_SITE_UID]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID], [ORDERED_DATE], [WARD_UID])
GO

CREATE INDEX IDX_IEN_VISTA_SITE_UID ON [dbo].[ADMISSION_REQ] ([IEN], [VISTA_SITE_UID])  
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Admission request table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'ORDER_TEXT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Provider''s id - person.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'PROVIDER_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date and time for the release.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'RELEASED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The medical person who signes the admission request document.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'SIGNED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time of signing the admission request document.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'SIGNED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility that was requested for the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the hospital location.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'HOSPITAL_LOCATION_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'ORDERED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If order is active.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'IS_ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indentity column imported from VistA(VistA IEN)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'IEN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the ward from where the patient will be admitted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'UID of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ', 'COLUMN', N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the order was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO