﻿using System;
using System.Collections.Generic;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using System.Linq;

namespace BMS.UnitTesting
{
    internal class AdmissionComparer : IEqualityComparer<Admission>
    {
        public bool Equals(Admission x, Admission y)
        {
            CDComparer cdComparer = new CDComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            PersonComparer personComparer = new PersonComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();            
            ActComparer actComparer = new ActComparer();

            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;
            if (!personComparer.Equals(x.AttendingNurse, y.AttendingNurse))
                return false;
            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;            
            if (!personComparer.Equals(x.Provider, y.Provider))
                return false;
            if (!dtComparer.Equals(x.ReleasedDate, y.ReleasedDate))
                return false;
            if (!personComparer.Equals(x.SignedBy, y.SignedBy))
                return false;
            if (!placeComparer.Equals(x.Ward, y.Ward))
                return false;

            return true;
        }

        public int GetHashCode(Admission obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class DischargeComparer : IEqualityComparer<Discharge>
    {
        public bool Equals(Discharge x, Discharge y)
        {
            ActComparer actComparer = new ActComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();
            PersonComparer personComparer = new PersonComparer();
            CDComparer cdComparer = new CDComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;
            if (!dtComparer.Equals(x.DischargedDate, y.DischargedDate))
                return false;
            if (!personComparer.Equals(x.EnteredBy, y.EnteredBy))
                return false;
            if (string.Compare(x.OrderText, y.OrderText, true) != 0)
                return false;
            if (!personComparer.Equals(x.Provider, y.Provider))
                return false;
            if (!dtComparer.Equals(x.ReleasedDate, y.ReleasedDate))
                return false;
            if (!personComparer.Equals(x.SignedBy, y.SignedBy))
                return false;
            if (!dtComparer.Equals(x.SignedDate, y.SignedDate))
                return false;            
            if (!cdComparer.Equals(x.MovementType, y.MovementType))
                return false;
            if (!placeComparer.Equals(x.Ward, y.Ward))
                return false;
            return true;
        }

        public int GetHashCode(Discharge obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class TransferComparer : IEqualityComparer<Transfer>
    {
        public bool Equals(Transfer x, Transfer y)
        {
            CDComparer cdComparer = new CDComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();
            ActComparer actComparer = new ActComparer();
            
            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.AdmissionFacility, y.AdmissionFacility))
                return false;
            if (string.Compare(x.Comment, y.Comment, true) != 0)
                return false;
            if (string.Compare(x.CurrentLocation, y.CurrentLocation, true) != 0)
                return false;
            if (!cdComparer.Equals(x.Contract, y.Contract))
                return false;
            if (string.Compare(x.Diagnosis, y.Diagnosis, true) != 0)
                return false;
            if (string.Compare(x.DischargeComment, y.DischargeComment, true) != 0)
                return false;
            if (!cdComparer.Equals(x.Disposition, y.Disposition))
                return false;
            if (!dtComparer.Equals(x.DispositionDate, y.DispositionDate))
                return false;
            if (!cdComparer.Equals(x.Era, y.Era))
                return false;
            if (!placeComparer.Equals(x.Facility, y.Facility))
                return false;

            return true;
        }

        public int GetHashCode(Transfer obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class MovementComparer : IEqualityComparer<Movement>
    {
        public bool Equals(Movement x, Movement y)
        {
            ActComparer actComparer = new ActComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;
            if (!cdComparer.Equals(x.MovementType, y.MovementType))
                return false;
            if (!placeComparer.Equals(x.Ward, y.Ward))
                return false;

            return true;
        }

        public int GetHashCode(Movement obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class DiversionComparer : IEqualityComparer<Diversion>
    {
        public bool Equals(Diversion x, Diversion y)
        {
            DateTimeComparer dtComparer = new DateTimeComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();

            if (x.Active != y.Active)
                return false;
            if (string.Compare(x.Comments, y.Comments, true) != 0)
                return false;
            if (!dtComparer.Equals(x.EndDate, y.EndDate))
                return false;
            if (!placeComparer.Equals(x.Facility, y.Facility))
                return false;
            if (!cdComparer.Equals(x.Location, y.Location))
                return false;
            if (!dtComparer.Equals(x.StartDate, y.StartDate))
                return false;
            return true;
        }

        public int GetHashCode(Diversion obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class BedCleaningOperationComparer : IEqualityComparer<BedCleaningOperation>
    {
        public bool Equals(BedCleaningOperation x, BedCleaningOperation y)
        {
            CDComparer cdComparer = new CDComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            ActComparer actComparer = new ActComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;
            if (!cdComparer.Equals(x.TypeOfClean, y.TypeOfClean))
                return false;            
            
            return true;
        }

        public int GetHashCode(BedCleaningOperation obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class BedOutOfServiceEventComparer : IEqualityComparer<BedUnavailable>
    {
        public bool Equals(BedUnavailable x, BedUnavailable y)
        {
            ActComparer actComparer = new ActComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.Bed, y.Bed))
                return false;
            if (!cdComparer.Equals(x.Reason, y.Reason))
                return false;
            if (!cdComparer.Equals(x.Type, y.Type))
                return false;
            return true;
        }

        public int GetHashCode(BedUnavailable obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class BedOccupancyInfoComparer : IEqualityComparer<BedOccupancyInfo>
    {
        public bool Equals(BedOccupancyInfo x, BedOccupancyInfo y)
        {
            ActComparer actComparer = new ActComparer();
            PersonComparer personComparer = new PersonComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();
                        
            if (!dtComparer.Equals(x.MovementDate, y.MovementDate))
                return false;
            if (x.LosAdmin.CompareTo(y.LosAdmin) != 0)
                return false;
            if (x.LosDrg.CompareTo(y.LosDrg) != 0)
                return false;
            if (x.LosWard.CompareTo(y.LosWard) != 0)
                return false;
            return true;
        }

        public int GetHashCode(BedOccupancyInfo obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class AdmissionInfoComparer : IEqualityComparer<AdmissionInfo>
    {
        public bool Equals(AdmissionInfo x, AdmissionInfo y)
        {
            ActComparer actComparer = new ActComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();
            TimeSpanComparer tsComparer = new TimeSpanComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.AssignedBedId, y.AssignedBedId))
                return false;
            if (!cdComparer.Equals(x.Authorization, y.Authorization))
                return false;
            if (!dtComparer.Equals(x.BedAssignedDate, y.BedAssignedDate))
                return false;
            if (string.Compare(x.CommentFee, y.CommentFee, true) != 0)
                return false;
            if (!cdComparer.Equals(x.Contract, y.Contract))
                return false;
            if (!cdComparer.Equals(x.FeeDisposition, y.FeeDisposition))
                return false; 
            if (string.Compare(x.Problem, y.Problem) != 0)
                return false;
            if (!cdComparer.Equals(x.ReasonFee, y.ReasonFee))
                return false;
            if (!dtComparer.Equals(x.RemovedDate, y.RemovedDate))
                return false;
            if (!dtComparer.Equals(x.RequestedDate, y.RequestedDate))
                return false;
            if (!cdComparer.Equals(x.ServiceReceive, y.ServiceReceive))
                return false;
            if (string.Compare(x.TypeOfBedWard, y.TypeOfBedWard) != 0)
                return false;
            if (!cdComparer.Equals(x.WaitingArea, y.WaitingArea))
                return false;
            if (!tsComparer.Equals(x.WaitTime, y.WaitTime))
                return false;
            return true;
        }

        public int GetHashCode(AdmissionInfo obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class TransferInfoComparer : IEqualityComparer<TransferInfo>
    {
        public bool Equals(TransferInfo x, TransferInfo y)
        {
            ActComparer actComparer = new ActComparer();
            PersonComparer personComparer = new PersonComparer();
            PlaceComparer placeComparer = new PlaceComparer();
            CDComparer cdComparer = new CDComparer();
            DateTimeComparer dtComparer = new DateTimeComparer();

            if (!actComparer.Equals(x, y))
                return false;
            if (!placeComparer.Equals(x.AdmissionFacilityId, y.AdmissionFacilityId))
                return false;
            if (string.Compare(x.Comment, y.Comment, true) != 0)
                return false;
            if (string.Compare(x.CurrentLocation, y.CurrentLocation, true) != 0)
                return false;
            if (!cdComparer.Equals(x.Contract, y.Contract))
                return false;
            if (string.Compare(x.Diagnosis, y.Diagnosis, true) != 0)
                return false;
            if (!dtComparer.Equals(x.DispositionDate, y.DispositionDate))
                return false;
            if (!cdComparer.Equals(x.Era, y.Era))
                return false;
            if (!placeComparer.Equals(x.FacilityId, y.FacilityId))
                return false;
            return true;
        }

        public int GetHashCode(TransferInfo obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class ActComparer : IIComparer, IEqualityComparer<Act>
    {
        public bool Equals(Act x, Act y)
        {
            DateTimeComparer dtComparer = new DateTimeComparer();
            PersonComparer personComparer = new PersonComparer();
            ParentComparer parentComparer = new ParentComparer();
            
            if (!dtComparer.Equals(x.CanceledDate, y.CanceledDate))
                return false;
            if (!dtComparer.Equals(x.CreationDate, y.CreationDate))
                return false;
            if (x.FlowId != y.FlowId)
                return false;
            if (!Equals(x.Id, y.Id))
                return false;
            if (!personComparer.Equals(x.Patient, y.Patient))
                return false;
            if (!parentComparer.Equals(x.Parent, y.Parent))
                return false;

            return true;
        }

        public int GetHashCode(Act obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class ConfigurationComparer : IEqualityComparer<Configuration>
    {
        public bool Equals(Configuration x, Configuration y)
        {            
            if (x.ConfigType != y.ConfigType)
                return false;
            if (string.Compare(x.Domain, y.Domain, true) != 0)
                return false;
            if (string.Compare(x.UserName, y.UserName, true) != 0)
                return false;
            return new ConfigDictionaryComparer().Equals(x.SectionList, y.SectionList);
        }

        public int GetHashCode(Configuration obj)
        {
            throw new NotImplementedException();
        }
    }

    #region base type comparers

    internal class ConfigDictionaryComparer : IEqualityComparer<Dictionary<string, List<Element>>>
    {
        public bool Equals(Dictionary<string, List<Element>> x, Dictionary<string, List<Element>> y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (x != null && y != null)
                {
                    if (x.Count != y.Count)
                        return false;
                    ElementListComparer elementListComparer = new ElementListComparer();
                    foreach (string key in x.Keys)
                    {
                        if (!y.Keys.Contains(key))
                            return false;
                        else
                        {
                            if (!elementListComparer.Equals(x[key], y[key]))
                                return false;                            
                        }
                    }                    
                    return true;
                }
            }
            catch { }
            return false;
        }

        public int GetHashCode(Dictionary<string, List<Element>> obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class ElementListComparer : IEqualityComparer<List<Element>>
    {
        public bool Equals(List<Element> x, List<Element> y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (x != null && y != null)
                {
                    if (x.Count != y.Count)
                        return false;
                    ElementComparer elementComparer = new ElementComparer();
                    for (int i = 0; i < x.Count; i++)
                    {
                        if (y.First<Element>(item => elementComparer.Equals(item, x[i])) == null)
                            return false;
                        if (x.First<Element>(item => elementComparer.Equals(item, y[i])) == null)
                            return false;
                    }
                    return true;
                }
            }
            catch { }
            return false;
        }

        public int GetHashCode(List<Element> obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class ElementComparer : IEqualityComparer<Element>
    {
        public bool Equals(Element x, Element y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (string.Compare(x.FriendlyName, y.FriendlyName, true) != 0)
                    return false;
                if (string.Compare(x.Key, y.Key, true) != 0)
                    return false;
                return new ANYComparer().Equals(x.Value, y.Value);                
            }
            catch { }
            return false;
        }

        public int GetHashCode(Element obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class ANYComparer : IEqualityComparer<ANY>
    {
        public bool Equals(ANY x, ANY y)
        {
            if (x == null && y == null)
                return true;
            if (x is INT && y is INT)
            {
                if (string.Compare((x as INT).value, (y as INT).value, true) != 0)
                    return false;
                return true;
            }
            if (x is ST && y is ST)
            {
                if (string.Compare((x as ST).text, (y as ST).text, true) != 0)
                    return false;
                return true;
            }
            if (x is BL && y is BL)
            {
                if (string.Compare((x as BL).value.ToString(), (y as BL).value.ToString(), true) != 0)
                    return false;
                return true;
            }
            if (x is REAL && y is REAL)
            {
                if (string.Compare((x as REAL).value, (y as REAL).value, true) != 0)
                    return false;
                return true;
            }
            if (x is TS && y is TS)
            {
                if (string.Compare((x as TS).value, (y as TS).value, true) != 0)
                    return false;
                return true;
            }
            if (x is CD && y is CD)
            {
                if (string.Compare((x as CD).code, (y as CD).code, true) != 0)
                    return false;
                if (string.Compare((x as CD).codeSystem, (y as CD).codeSystem, true) != 0)
                    return false;
                if (string.Compare((x as CD).codeSystemName, (y as CD).codeSystemName, true) != 0)
                    return false;
                if (string.Compare((x as CD).displayName, (y as CD).displayName, true) != 0)
                    return false;
                return true;
            }
            if (x is EntityIdentification && y is EntityIdentification)
            {
                if (string.Compare((x as EntityIdentification).EntityIdentifier, (y as EntityIdentification).EntityIdentifier, true) != 0)
                    return false;
                if (string.Compare((x as EntityIdentification).EntityName, (y as EntityIdentification).EntityName, true) != 0)
                    return false;
                if (string.Compare((x as EntityIdentification).EntityTypeIdentifier, (y as EntityIdentification).EntityTypeIdentifier, true) != 0)
                    return false;
                return true;
            }
            return false;
        }

        public int GetHashCode(ANY obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class TimeSpanComparer : IEqualityComparer<TimeSpan?>
    {
        public bool Equals(TimeSpan? x, TimeSpan? y)
        {
            if (!x.HasValue && !y.HasValue)
                return true;
            if (x.HasValue && y.HasValue && Math.Abs(x.Value.Seconds-y.Value.Seconds) <= 1)
                return true;
            return false;
        }

        public int GetHashCode(TimeSpan? obj)
        {
            throw new NotImplementedException();
        }
    }   

    internal class ParentComparer : IEqualityComparer<Act>
    {
        public bool Equals(Act x, Act y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (x.Parent == null && y.Parent == null)
                    return true;
                return new IIComparer().Equals(x.Parent.Id, y.Parent.Id);
            }
            catch { }
            return false;
        }

        public int GetHashCode(Act obj)
        {
            throw new NotImplementedException();
        }
    }    

    internal class DateTimeComparer : IEqualityComparer<DateTime?>
    {
        public bool Equals(DateTime? x, DateTime? y)
        {
            if(!x.HasValue && !y.HasValue)
                return true;
            if (x.HasValue && y.HasValue && x.Value.ToUniversalTime().Subtract(y.Value.ToUniversalTime()).TotalSeconds < 1)
                return true;
            return false;
        }

        public int GetHashCode(DateTime? obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class IIComparer : IEqualityComparer<II>
    {
        public bool Equals(II x, II y)
        {
            try
            {
                return
                    Math.Abs(string.Compare(x.root, y.root, true)) +
                    Math.Abs(string.Compare(x.extension, y.extension, true)) <= 1;
            }
            catch { }
            //should have returned false
            return true;
        }

        public int GetHashCode(II obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class CDComparer : IEqualityComparer<CD>
    {
        public bool Equals(CD x, CD y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                return
                    Math.Abs(string.Compare(x.code, y.code, true)) +
                    Math.Abs(string.Compare(x.codeSystem, y.codeSystem, true)) +
                    Math.Abs(string.Compare(x.codeSystemName, y.codeSystemName, true)) +
                    Math.Abs(string.Compare(x.displayName, y.displayName, true)) == 0;
            }
            catch { }
            return false;
        }

        public int GetHashCode(CD obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class PlaceComparer : IIComparer, IEqualityComparer<Place>
    {
        public bool Equals(Place x, Place y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (!Equals(x.Id, y.Id))
                    return false;
                return string.Compare(x.Name, y.Name, true) == 0;
            }
            catch { }
            return false;
        }

        public int GetHashCode(Place obj)
        {
            throw new NotImplementedException();
        }
    }

    internal class PersonComparer : IIComparer, IEqualityComparer<Person>
    {
        public bool Equals(Person x, Person y)
        {
            if (x == null && y == null)
                return true;
            try
            {
                if (!Equals(x.Id, y.Id))
                    return false;
                if (!Equals(x.SSN, y.SSN))
                    return false;
                return
                    Math.Abs(string.Compare(x.FirstName, y.FirstName, true)) +
                    Math.Abs(string.Compare(x.LastName, y.LastName, true)) +
                    Math.Abs(string.Compare(x.MiddleName, y.MiddleName, true)) == 0;
            }
            catch { }
            return false;
        }

        public int GetHashCode(Person obj)
        {
            throw new NotImplementedException();
        }
    }
    #endregion
}
