﻿using System;
using System.Collections.Generic;
using System.Text;
using BMS.Schedulers;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.Facade;

namespace BMS.WhiteboardReport
{
    public class WhiteboardReportCommand : BaseCommand
    {
        public List<Facility> facilities;
        private static BmsLogger logger = new BmsLogger("WhiteboardReport:");

        public WhiteboardReportCommand(List<Facility> _facilities)
        {
            this.facilities = _facilities;
        }

        protected override void DoRun(Scheduler scheduler)
        {
            StringBuilder sb = new StringBuilder();
            facilities.ForEach(a => sb.Append(a.Code + "; "));
            //string message = string.Format("Run Whiteboard Report command by scheduler {0} for facilities: {1}", scheduler.Name, sb);
            FacadeManager.BedInterface.ExportWhiteboardReportData(facilities);
            logger.LogFormat(BmsLogger.Level.Info,"Run Whiteboard Report command by scheduler {0} for facilities: {1}", scheduler.Name, sb);
        }
    }
}
