﻿/// <reference path="jquery-1.4.4-vsdoc.js" />
/// <reference path="jquery.validate.unobtrusive.js" />

(function ($) {
    var reqIfValidator = function (value, element, params) {
        var values = null;
        var others = params.others.split(',');
        var reqVal = params.reqval + "";
        var currentVal = value + "";

        if (params.values + "" != "")
            values = params.values.split(',')

        var retVal = false;
        //Validate Dependent Prop Values First
        $.each(others, function (index, value) {
            var $other = $('#' + value);
            var currentOtherVal = ($other.attr('type') != null && $other.attr('type').toUpperCase() == "CHECKBOX") ?
                                    ($other.attr("checked") ? "true" : "false") :
                                    $other.val();
            var requiredOtherVal = "val";
            if (values != null)
                requiredOtherVal = values[index];

            if (requiredOtherVal == "val" && currentOtherVal == "")
                retVal = true;
            else if (requiredOtherVal == "" && currentOtherVal != "")
                retVal = true;
            else if (requiredOtherVal != "" && requiredOtherVal != "val" &&
                     requiredOtherVal != currentOtherVal) {
                retVal = true;
            }

            if (retVal == true) {
                return false;
            }
        });

        if (retVal == true)
            return true;

        if (reqVal == "val" && currentVal == "")
            return false;
        else if (reqVal == "" && currentVal != "")
            return false;
        else if (reqVal != "" && reqVal != "val" && reqVal != currentVal)
            return false;

        return true;
    }

    var reqIfMultipleValidator = function (value, element, params) {
        var others = params.others.split('!');
        var reqVals = params.reqval.split('!');
        var msgs = params.errorMsgs.split('!');
        var errMsg = "";

        var values = null;
        if (params.values + "" != "")
            values = params.values.split('!')

        var retVal = true;
        $.each(others, function (index, val) {

            var myParams = { "others": val, "reqval": reqVals[index],
                "values": values[index]
            };
            retVal = reqIfValidator(value, element, myParams);
            if (retVal == false) {
                errMsg = msgs[index];
                return false;
            }
        });
        if (retVal == false) {
            var evalStr = "this.settings.messages." + $(element).attr("name") +
                     ".requiredifmultiple='" + errMsg + "'";
            eval(evalStr);
        }
        return retVal;
    }

    $.validator.addMethod("requiredif", reqIfValidator);
    $.validator.addMethod("requiredifmultiple", reqIfMultipleValidator);
    $.validator.unobtrusive.adapters.add("requiredif", ["reqval", "others", "values"],
        function (options) {
            options.rules['requiredif'] = {
                reqval: options.params.reqval,
                others: options.params.others,
                values: options.params.values
            };
            options.messages['requiredif'] = options.message;
        });
    $.validator.unobtrusive.adapters.add(
          "requiredifmultiple", ["reqval", "others", "values"],
        function (options) {
            options.rules['requiredifmultiple'] = {
                reqval: options.params.reqval,
                others: options.params.others,
                values: options.params.values,
                errorMsgs: options.message
            };
            options.messages['requiredifmultiple'] = "";
        });
    } (jQuery));


$.validator.addMethod('requiredifaction',
    function (value, element, parameters) {
        var id = '#' + parameters['dependentproperty'];
        var action = parameters['dependentaction'];

        // get the target value (as a string, 
        // as that's what actual value will be)
        var targetvalue = parameters['targetvalue'];
        targetvalue =
          (targetvalue == null ? '' : targetvalue).toString();

        // get the actual value of the target control
        // note - this probably needs to cater for more 
        // control types, e.g. radios
        var control = $(id);
        var controltype = control.attr('type');
        var actualvalue =
            controltype === 'checkbox' ?
            control.prop('checked').toString() :
            controltype === 'button' ?
            control.attr('name').toString() :
            control.val();

        // if the condition is true, reuse the existing 
        // required field validator functionality
        if (jQuery.inArray(action, window.clicked.split('|')) >=0 && targetvalue === actualvalue)
            return $.validator.methods.required.call(
              this, value, element, parameters);

        return true;
    });

    $.validator.unobtrusive.adapters.add(
    'requiredifaction',
    ['dependentproperty', 'dependentaction', 'targetvalue'],
    function (options) {
        options.rules['requiredifaction'] = {
            dependentproperty: options.params['dependentproperty'],
            dependentaction: options.params['dependentaction'],
            targetvalue: options.params['targetvalue']
        };
        options.messages['requiredifaction'] = options.message;
    });

//    $.validator.addMethod('rangeif',
//    function (value, element, parameters) {
//        var id = '#' + parameters['dependentproperty'];

//        // get the target value (as a string, 
//        // as that's what actual value will be)
//        var targetvalue = parameters['targetvalue'];
//        targetvalue =
//          (targetvalue == null ? '' : targetvalue).toString();

//        // get the actual value of the target control
//        // note - this probably needs to cater for more 
//        // control types, e.g. radios
//        var control = $(id);
//        var controltype = control.attr('type');
//        var actualvalue =
//            controltype === 'checkbox' ?
//            control.attr('checked').toString() :
//            control.val();

//        // if the condition is true, reuse the existing 
//        // required field validator functionality
//        if (targetvalue === actualvalue) {
//            var rangeArray = new Array(2);
//            rangeArray[0] = parseFloat(parameters['minimum']);
//            rangeArray[1] = parseFloat(parameters['maximum']);
//            return $.validator.methods.range.call(
//              this, value, element, rangeArray);
//        }

//        return true;
//    });

//    $.validator.unobtrusive.adapters.add(
//    'rangeif',
//    ['dependentproperty', 'targetvalue', 'minimum', 'maximum'],
//    function (options) {
//        options.rules['rangeif'] = {
//            dependentproperty: options.params['dependentproperty'],
//            targetvalue: options.params['targetvalue'],
//            minimum: options.params['minimum'],
//            maximum: options.params['maximum']
//        };
//        options.messages['rangeif'] = options.message;
//    });