﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.ComponentModel.DataAnnotations;
using BMS.Web.App_GlobalResource;
using BMS.Utils;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model for Select Patient view on Transfer controller.
    /// </summary>
    public class TransferSelectPatientViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the patient search text.
        /// </summary>
        /// <value>
        /// The patient search text.
        /// </value>
        [Required(ErrorMessage = "Please enter Last Name, or full SSN, or Last Initial & Last 4 SSN!")]
        [RegularExpression(Constants.PATIENT_SEARCH_REGULAR_EXPRESSION, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "SearchStringToShort")]
        [ValidateXss]
        public string PatientSearchText { get; set; }

        /// <summary>
        /// Gets or sets the patient list.
        /// </summary>
        /// <value>
        /// The patient list.
        /// </value>
        public List<Patient> PatientList { get; set; }

        /// <summary>
        /// Gets or sets the selected patient id.
        /// </summary>
        /// <value>
        /// The selected patient id.
        /// </value>
        public string SelectedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the visn extension.
        /// </summary>
        /// <value>
        /// The visn extension.
        /// </value>
        public string VisnExtension { get; set; }

        /// <summary>
        /// Gets or sets the visn root.
        /// </summary>
        /// <value>
        /// The visn root.
        /// </value>
        public string VisnRoot { get; set; }

        /// <summary>
        /// Gets or sets the visn number.
        /// </summary>
        /// <value>
        /// The visn number.
        /// </value>
        public string VisnNumber { get; set; }

        /// <summary>
        /// Gets or sets the facility list.
        /// </summary>
        /// <value>
        /// The facility list.
        /// </value>        
        public IList<Facility> FacilityList { get; set; }

        /// <summary>
        /// Gets or sets the selected facility id.
        /// </summary>
        /// <value>
        /// The selected facility id.
        /// </value>
        [RegularExpression(@"^((?!Responsible Facility).*)$", ErrorMessage = "Facility is required!")]
        public string SelectedFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the facility id parameter.
        /// </summary>
        /// <value>
        /// The facility id param.
        /// </value>
        public string FacilityIdParam { get; set; }

        /// <summary>
        /// Gets or sets the selected sort parameter.
        /// </summary>
        /// <value>
        /// The selected sort param.
        /// </value>
        public string SelectedSortParam { get; set; }

        /// <summary>
        /// Gets or sets the current page parameter.
        /// </summary>
        /// <value>
        /// The current page param.
        /// </value>
        public int? CurrentPageParam { get; set; }

        /// <summary>
        /// Gets or sets the patient not found.
        /// </summary>
        /// <value>
        /// The patient not found.
        /// </value>
        public string PatientNotFound { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is go back home page.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is go back home page; otherwise, <c>false</c>.
        /// </value>
        public bool IsGoBackHomePage { get; set; }
    }
}