﻿using System;
using System.Linq;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using Microsoft.Web.Mvc;
using BMS.Facade.Data;
using System.Collections.Generic;
using BMS.Utils;
using InfoWorld.HL7.ITS;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class UserConfigurationController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(string p)
        {
            UserConfigurationViewModel model = new UserConfigurationViewModel();
            model.Data = GetUser(string.IsNullOrEmpty(p) ? null : QueryStrings["id"]);
            model.SiteName = this.loggedUser.Facility.Code + " - " + this.loggedUser.Facility.Name;
            model.VISNNo = this.loggedUser.Visn.Number;
            model.RegionNo = this.loggedUser.Visn.Region.Number.ToString();
            model.StrictDecisions = Facade.FacadeManager.VocabularyInterface.GetVocabulary(BMS.Facade.Data.Util.Vocabulary.StrictDecision);
            if (!model.IsDefaultUser)
            {
                FacadeManager.UserInterface.FillUserData(model.Data);
                PermissionFacility permissionFacility = FacadeManager.UserInterface.GetFacilitiesForReadAndWrite(model.Data.UserName, new List<Facility>() { this.loggedUser.Facility }).FirstOrDefault();
                if (permissionFacility != null)
                {
                    model.Data.ReadAccess = permissionFacility.ReadAccess == true ? model.StrictDecisions.Where(a => a.code.Equals(Constants.Yes, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() : model.StrictDecisions.Where(a => a.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    model.Data.WriteAccess = permissionFacility.WriteAccess == true ? model.StrictDecisions.Where(a => a.code.Equals(Constants.Yes, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() : model.StrictDecisions.Where(a => a.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                }
                else
                {
                    model.Data.ReadAccess = model.StrictDecisions.Where(a => a.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    model.Data.WriteAccess = model.StrictDecisions.Where(a => a.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                }
            }
            model.LoggedUser = loggedUser;
            return View(model);
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index(UserConfigurationViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.LoggedUser = loggedUser;
                if (model.Data.UserName == Constants.DEFAULT_USER_PROFILE)
                {
                    ModelState.AddModelError(string.Empty, "Select an existing NT User Name.");
                    return View(model);
                }

                if (model.Data.ReadAccess == null || model.Data.ReadAccess.code == Constants.No)
                {
                    ModelState.AddModelError(string.Empty, "Read Access is required for this facility.");
                    model.SiteName = this.loggedUser.Facility.Code + " - " + this.loggedUser.Facility.Name;
                    model.VISNNo = this.loggedUser.Visn.Number;
                    model.RegionNo = this.loggedUser.Visn.Region.Number.ToString();
                    model.StrictDecisions = Facade.FacadeManager.VocabularyInterface.GetVocabulary(BMS.Facade.Data.Util.Vocabulary.StrictDecision);
                    return View(model);
                }

                model.Data.Facility = FacadeManager.EntityInterface.GetFacility(new II(this.loggedUser.Domain, this.loggedUser.Facility.Id.extension));
                FacadeManager.ConfigurationInterface.SaveUserProfile(model.Data);
                if (!model.IsDefaultUser)
                {                    
                    PermissionFacility permissionFacility = new PermissionFacility();
                    permissionFacility.Facility = this.loggedUser.Facility;
                    permissionFacility.ReadAccess = true;
                    if (model.Data.WriteAccess != null && model.Data.WriteAccess.code == Constants.Yes)
                        permissionFacility.WriteAccess = true;
                    else
                        permissionFacility.WriteAccess = false;
                    FacadeManager.UserInterface.SaveUserData(model.Data, permissionFacility);
                }
                return View("UserEditHasSaved", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult SelectUser()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SelectUserModel model = new SelectUserModel();
                model.Domains = FacadeManager.UserInterface.GetUserDomains();
                model.SelectedDomain = model.Domains.First();
                model.Users = FacadeManager.UserInterface.SearchUsers(model.SelectedDomain, model.SearchText);                
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult SearchUser(SelectUserModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.Domains = FacadeManager.UserInterface.GetUserDomains();
                model.Users = FacadeManager.UserInterface.SearchUsers(model.SelectedDomain, !string.IsNullOrEmpty(model.SearchText) ? model.SearchText.Trim() : model.SearchText);
                model.LoggedUser = loggedUser;
                return View("SelectUser", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult SelectUser(SelectUserModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction<UserConfigurationController>(act => act.Index(EncryptQueryString(new string[] { "id" }, new string[] { model.SelectedUserId }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
