﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.Security;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Utils;
using BMS.Facade.Data;
using BMS.Facade;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Security.DurableIssuedToken;

namespace BMS.Web.Controllers
{


    public class SiteListController : BaseController
    {
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SiteListModel model = new SiteListModel();
                FillModel(model);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        [HttpPost]
        [ActionName("Index")]
        [MultiButtonAttribute]
        public ActionResult GoToHome(SiteListModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool successfullyConnect = TryConnect(model);
                if (successfullyConnect)
                    return this.RedirectToAction<HomeController>(act => act.Index());
                FillModel(model);
                return View("Index", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ActionName("Index")]
        [MultiButtonAttribute]
        public ActionResult GoToBedCleaning(SiteListModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool successfullyLog = TryConnect(model);
                if (successfullyLog)
                    return this.RedirectToAction<EmsBedStatusAdminController>(act => act.Index(BaseController.EncryptQueryString(new string[] { "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { string.Empty, string.Empty, string.Empty, string.Empty, string.Empty }, loggedUser.Salt)));
                FillModel(model);
                return View("Index", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        private bool TryConnect(SiteListModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!ModelState.IsValid)
                    return false;

                User user = FacadeManager.UserInterface.GetProfile();
                if (!FacadeManager.UserInterface.CheckBMSReadPermission(user, new II(user.Domain, model.FacilityId)))
                {
                    ModelState.AddModelError(string.Empty, "The user name does not have permissions for the selected facility.");
                    return false;
                }
                
                Facility facility = FacadeManager.EntityInterface.GetFacility(new II(user.Domain, model.FacilityId));
                user.Facility = facility;
                user.Visn = facility.VistaSite.Visn;
                if (user.Visn == null)
                {
                    ModelState.AddModelError("FacilityId", "The facility doesn't have an associated VISN");
                    return false;
                }
                user.Region = facility.VistaSite.Visn.Region;
                if (user.Region == null)
                {
                    ModelState.AddModelError("FacilityId", "The VISN on facility doesn't have an associated Region");
                    return false;
                }
                return true;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void FillModel(SiteListModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    model.UserName = this.loggedUser.UserName;
                    IList<Facility> allFacilities = FacadeManager.EntityInterface.GetFacilitiesUsingWindowsAuthentication().Where(facility => facility.IsAlive == true).ToList();
                    if (allFacilities == null)
                        allFacilities = new List<Facility>();
                    model.FacilityList = allFacilities.OrderBy(a => ((a.Address1 != null) ? (!string.IsNullOrEmpty(a.Address1.city) ? a.Address1.city : string.Empty) : string.Empty))
                                            .Select(f => new Facility { Id = f.Id, Name = ((f.Address1 != null) ? (!string.IsNullOrEmpty(f.Address1.city) ? f.Address1.city : string.Empty) : string.Empty) + " (" + f.SiteNumber + ", " + f.Code + ")" }).ToList();
                    Facility selectedFacility = allFacilities.Count > 0 ? allFacilities.FirstOrDefault() : null;
                    model.FacilityId = selectedFacility == null ? string.Empty : selectedFacility.Id.extension;
                    model.LoggedUser = loggedUser;
                }
                catch (Exception e)
                {
                    ModelState.AddModelError("", "Can't get the facilities: " + e.Message);
                    model.FacilityList = new Facility[0];
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
