﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Reflection;

namespace BMS.Web.Controllers.Shared
{
    /// <summary>
    /// Affects the selection of an action method to handle multiple submit buttons on a form.
    /// </summary>
    public class MultiButtonAttribute : ActionNameSelectorAttribute
    {
        public override bool IsValidName(ControllerContext controllerContext, string actionName, MethodInfo methodInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //if (actionName.Equals(methodInfo.Name, StringComparison.InvariantCultureIgnoreCase))
                //    return true;

                //if (!actionName.Equals(Action, StringComparison.InvariantCultureIgnoreCase))
                //    return false;

                var request = controllerContext.RequestContext.HttpContext.Request;
                bool result = request[methodInfo.Name] != null;
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}