﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.ServicesWrapper.Security;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class EmsStaffController : BaseController
    {
        [ReadPermissionAuthFilter]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsStaffViewModel model = new EmsStaffViewModel();
                model.EmsUserList = FacadeManager.UserInterface.FilterEmsStaff(this.loggedUser.Facility);
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsStaffViewModel model = new EmsStaffViewModel();
                model.EmsStaffId = QueryStrings["id"];
                model.EMSUsers = GetEMSUsers();
                model.EMSUsers.Insert(0, string.Empty);
                if (!string.IsNullOrEmpty(model.EmsStaffId) && int.Parse(model.EmsStaffId) > 0)
                {
                    EmsStaff ems = FacadeManager.UserInterface.GetEmsStaff(new II(this.loggedUser.Domain, model.EmsStaffId));
                    model.EmsUserName = ems.UserName;
                    model.Pin = ems.Pin;
                }
                if (model.EmsStaffId.Equals("-1"))
                    model.EmsStaffId = null;
                model.RadioCheckedValue = Constants.Yes;
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Edit(EmsStaffViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ModelState.Clear();
                input.LoggedUser = loggedUser;
                input.EmsUserList = FacadeManager.UserInterface.FilterEmsStaff(this.loggedUser.Facility);
                if (string.IsNullOrEmpty(input.EmsStaffId) || int.Parse(input.EmsStaffId) <= 0)
                {                    
                    if (input.EmsUserList.Where(a => a.UserName.Equals(input.EmsUserName, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                        ModelState.AddModelError(string.Empty, "The EMS User name already exists!");
                    if (input.EmsUserList.Where(a => a.Pin.Equals(input.Pin, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                        ModelState.AddModelError(string.Empty, "The PIN is already used by another user!");
                }
                else
                {
                    if (input.EmsUserList.Where(a => a.Pin.Equals(input.Pin, StringComparison.InvariantCultureIgnoreCase) && !a.Id.extension.Equals(input.EmsStaffId, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                        ModelState.AddModelError(string.Empty, "The PIN is already used by another user!");
                }
                if (!ModelState.IsValid)
                {
                    input.EMSUsers = GetEMSUsers();
                    return View(input);
                }
                EmsStaff ems = new EmsStaff();
                if (!string.IsNullOrEmpty(input.EmsStaffId) && int.Parse(input.EmsStaffId) > 0)
                    ems = FacadeManager.UserInterface.GetEmsStaff(new II(this.loggedUser.Domain, input.EmsStaffId));
                else
                    ems.Id = new II(this.loggedUser.Domain, "-1");

                ems.Facility = this.loggedUser.Facility;
                ems.Pin = input.Pin;
                ems.UserName = input.EmsUserName;
                if (ems.Id.extension.Equals("-1"))
                    FacadeManager.UserInterface.CreateEmsStaff(ems);
                else
                    FacadeManager.UserInterface.UpdateEmsStaff(ems);

                return this.RedirectToAction<EmsStaffController>(act => act.Index());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsStaffViewModel model = new EmsStaffViewModel();
                model.EmsStaffId = QueryStrings["id"];
                EmsStaff ems = FacadeManager.UserInterface.GetEmsStaff(new II(this.loggedUser.Domain, model.EmsStaffId));
                model.EmsUserName = ems.UserName;
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Delete(EmsStaffViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.UserInterface.DeleteEmsStaff(new II(this.loggedUser.Domain, input.EmsStaffId));
                return this.RedirectToAction<EmsStaffController>(act => act.Index());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods

        private List<string> GetEMSUsers()
        {
            List<User> EMSUserList = FacadeManager.UserInterface.GetUsersByRoleAndFacility(Constants.EMS_USER_ROLE, this.loggedUser.Facility.Id);
            return (from a in EMSUserList
                    orderby a.UserName
                    select a.UserName).Distinct().ToList();
        }

        #endregion
    }
}
