﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.Security;
using BMS.ServiceContracts;
using System.Threading;
using BMS.Utils;

namespace BMS.Web
{
    [ServiceBehavior(IgnoreExtensionDataObject = true, InstanceContextMode = InstanceContextMode.PerSession, ConcurrencyMode = ConcurrencyMode.Multiple, IncludeExceptionDetailInFaults = true, UseSynchronizationContext = false)]
    public class CacheService : ICacheService
    {
        #region EIS

        public void CacheEisEntity(string entityType, II id)
        {
            try
            {
                switch (entityType)
                {
                    case "Bed":
                        EISFactory.InstanceWindows.CacheBed(id);
                        break;
                    case "Ward":
                        EISFactory.InstanceWindows.CacheWard(id);
                        break;
                    case "Division":
                        EISFactory.InstanceWindows.CacheDivision(id);
                        break;
                    case "Facility":
                        EISFactory.InstanceWindows.CacheFacility(id);
                        break;
                    case "VistaSite":
                        EISFactory.InstanceWindows.CacheVistaSite(id);
                        break;
                    case "Visn":
                        EISFactory.InstanceWindows.CacheVisn(id);
                        break;
                    case "Region":
                        EISFactory.InstanceWindows.CacheRegion(id);
                        break;
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("CacheEisEntity entity - " + entityType + ", id = " + id.extension);
                Tracer.TraceException(ex);
            }
        }

        public void RemoveCacheEisEntity(string entityType, II id)
        {
            try
            {
                switch (entityType)
                {
                    case "Bed":
                        EISFactory.InstanceWindows.RemoveCacheBed(id);
                        break;
                    case "Ward":
                        EISFactory.InstanceWindows.RemoveCacheWard(id);
                        break;
                    case "Division":
                        EISFactory.InstanceWindows.RemoveCacheDivision(id);
                        break;
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("RemoveCacheEisEntity entity - " + entityType + ", id = " + id.extension);
                Tracer.TraceException(ex);
            }
        }

        #endregion

        #region EVS

        public void CacheCD(string vocabularyDomain, string code)
        {
            try
            {
                EVSFactory.InstanceWindows.CacheCD(vocabularyDomain, code);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("CacheCD vocabulary - " + vocabularyDomain + ", code = " + code);
                Tracer.TraceException(ex);
            }
        }

        public void RemoveCacheCD(string vocabularyDomain, string code)
        {
            try
            {
                EVSFactory.InstanceWindows.RemoveCacheCD(vocabularyDomain, code);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("RemoveCacheCD vocabulary - " + vocabularyDomain + ", code = " + code);
                Tracer.TraceException(ex);
            }
        }        

        #endregion

        #region Security

        public void ClearUserPermissionCache(string userName)
        {
            try
            {
                SecurityFactory.InstanceWindows.ClearUserPermissionCache(userName);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("ClearUserPermissionCache for userName: " + userName);
                Tracer.TraceException(ex);
            }
        }

        public void CachePoliciesForOrganizations()
        {
            try
            {
                SecurityFactory.InstanceWindows.CachePoliciesForOrganizations();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("CachePoliciesForOrganizations");
                Tracer.TraceException(ex);
            }
        }        

        public void CacheUserRoles(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user)
        {
            try
            {
                SecurityFactory.InstanceWindows.CacheUserRoles(user);
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("CacheUserRoles");
                Tracer.TraceException(ex);
            }
        }

        #endregion

        public void RefreshCache()
        {
            try
            {
                EISFactory.InstanceWindows.FillCache();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("RefreshCache - EIS");
                Tracer.TraceException(ex);
            }
            try
            {
                EVSFactory.InstanceWindows.FillCache();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("RefreshCache - EVS");
                Tracer.TraceException(ex);
            }
            try
            {
                SecurityFactory.InstanceWindows.FillCache();
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("RefreshCache - Security");
                Tracer.TraceException(ex);
            }
        }
    }
}
