﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.LogCheckers;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.Security;
using BMS.ServicesWrapper.EVS;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.BMService;
using BMS.Utils;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper;
using System.Configuration;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class DeletedPatientMovementsProcessor : MultipleEntryProcessor
    {
        public Parameter Parameter { get; private set; }
        public IVistAQuery Query { get; private set; }
        public DeletedPatientMovementsProcessor(IWriterManager writerManager, Parameter parameter, IVistAQuery query)
            : base(writerManager)
        {
            if (parameter.Type != VistaDataType.PatientMovementIen)
                throw new InvalidOperationException();
            Parameter = parameter;
            Query = query;
            InitEntriesProcessor(GetEntitiesProcessor());
        }

        ListEntryProcessor<T> GetEntitiesProcessor<T>(Func<IList<T>> fetchFunc, Comparison<T> comparison, Func<T, DateTime?> filterDateTimeFunc)
        {
            IList<T> list = fetchFunc();
            if (list != null && list.Count > 0)
                list = (from a in (list as List<PatientMovement>) orderby a.EnteredOnDateTime select a).ToList() as List<T>;
            return new ListEntryProcessor<T>(WriterManager, list, filterDateTimeFunc);
        }

        public IVistaIntegrationLogChecker LogChecker { get; private set; }

        private IList<IEntryProcessor> GetEntitiesProcessor()
        {
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            VistaIntegration.Data.VistASite VistaSite = WriterManager.Site;
            II vistASiteId = new II(domain, VistaSite.Id);            

            List<IEntryProcessor> result = new List<IEntryProcessor>();
            List<VistaIntegrationLog> logs = new List<VistaIntegrationLog>();

            // get movements from BMS database
            DateTime startDate = Parameter.StartDateParam.Value;
            DateTime endDate = Parameter.EndDateParam.Value;
            if (Parameter.JobLaunchType == JobLaunchType.Automatic)
            {
                startDate = new DateTime(Parameter.StartDateParam.Value.Year, Parameter.StartDateParam.Value.Month, 1, 0, 0, 0);
                endDate = new DateTime(Parameter.EndDateParam.Value.Year, Parameter.EndDateParam.Value.Month, DateTime.DaysInMonth(Parameter.EndDateParam.Value.Year, Parameter.EndDateParam.Value.Month), 23, 59, 59);
            }            
            DateTime utcStartDate = VistaSite.ConvertToUtcDateTime(startDate);
            DateTime utcEndDate = VistaSite.ConvertToUtcDateTime(endDate);
            // get bms data
            List<MovementIen> bmsMovements = BMSFactory.BedManagerQueryClientWindows.GetMovementIens(utcStartDate, utcEndDate, vistASiteId);
            List<MovementWithoutBed> bmsMovementsWithoutBed = BMSFactory.BedManagerQueryClientWindows.FilterMovementsWithoutBed(utcStartDate, utcEndDate, vistASiteId);
            
            if ((bmsMovements != null && bmsMovements.Count > 0) || (bmsMovementsWithoutBed != null && bmsMovementsWithoutBed.Count > 0))
            {
                // get movements from vista site
                IList<PatientMovementIen> vistaMovements = Query.GetPatientMovementIens(startDate, endDate);
                if (vistaMovements != null && vistaMovements.Count > 0)
                {                    
                    Dictionary<string, PatientMovementIen> vistaMovementsDictionary = vistaMovements.ToDictionary(a => a.IEN);
                    vistaMovements = null;
                    if (bmsMovements != null && bmsMovements.Count > 0)
                    {                        
                        Dictionary<string, MovementIen> bmsMovementsDictionary = bmsMovements.ToDictionary(a => a.Ien);
                        bmsMovements = null;
                        // items which exists in BMS, but not exists in Vista, needs to be deleted
                        List<string> forDelete = bmsMovementsDictionary.Keys.Except(vistaMovementsDictionary.Keys).ToList();
                        // items which exists in Vista, but not exists in BMS, needs to be inserted
                        List<string> forInsert = vistaMovementsDictionary.Keys.Except(bmsMovementsDictionary.Keys).ToList();

                        List<string> forDeleteWithNoCheck = new List<string>();
                        
                        #region Select movements for update
                        
                        // compare movement fields for update or delete + insert
                        MovementIen movement = null;
                        FC.Patient patient = null;
                        string patientIen = null;                        

                        List<CD> typeOfMovements = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = FC.Util.Vocabulary.TypeOfMovement.ToString(), MaxSelectedCodes = int.MaxValue }).ToList();
                        
                        CD cdTom = null;
                        AdmissionEvent admEvent = null;
                        MovementEvent movEvent = null;
                        DischargeEvent disEvent = null;
                        SpecialtyTransfer spEvent = null;
                        DateTime movementDateUtc; DateTime enteredDateUtc;
                        bool isDifferentMovement = false;
                        foreach (PatientMovementIen pm in vistaMovementsDictionary.Values)
                        {                            
                            try
                            {
                                movement = bmsMovementsDictionary[pm.IEN];
                            }
                            catch { movement = null; }
                            isDifferentMovement = false;
                            if (movement != null)
                            {
                                enteredDateUtc = VistaSite.ConvertToUtcDateTime(pm.EnteredDate);
                                if (movement.CurrentAdmissionIen != pm.CurrentAdmissionIen || movement.EnteredDate != enteredDateUtc || pm.TransactionTypeId.Substring(0, 1) != movement.TransactionTypeId)
                                {
                                    if (movement.CurrentAdmissionIen != pm.CurrentAdmissionIen || pm.TransactionTypeId.Substring(0, 1) != movement.TransactionTypeId)
                                    {
                                        //movement was deleted from vista and inserted a new one with same ien
                                        forDelete.Add(pm.IEN);
                                        forDeleteWithNoCheck.Add(pm.IEN);
                                        forInsert.Add(pm.IEN);
                                        isDifferentMovement = true;
                                    }
                                    else
                                    {
                                        patient = EISFactory.InstanceWindows.GetPatientById(new II(domain, movement.PatientUid), VistaSite.Name);
                                        patientIen = null;
                                        if (patient != null)
                                        {
                                            try
                                            {
                                                patientIen = patient.IENList.Where(a => a.root.Equals(VistaSite.Name, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().extension;
                                            }
                                            catch { patientIen = null; }
                                        }
                                        if (patientIen != pm.PatientIen)
                                        {
                                            //movement was deleted from vista and inserted a new one with same ien
                                            forDelete.Add(pm.IEN);
                                            forDeleteWithNoCheck.Add(pm.IEN);
                                            forInsert.Add(pm.IEN);
                                            isDifferentMovement = true;
                                        }
                                    }
                                }
                                if (!isDifferentMovement)
                                {
                                    movementDateUtc = VistaSite.ConvertToUtcDateTime(pm.MovementDate);
                                    if (movement.EnteredDate != enteredDateUtc || movement.MovementDate != movementDateUtc ||
                                        (!string.IsNullOrEmpty(movement.TypeOfMovementCode) && movement.TypeOfMovementCode.Substring(movement.TypeOfMovementCode.IndexOf("_") + 1) != pm.TypeOfMovementIen)
                                        || (string.IsNullOrEmpty(movement.TypeOfMovementCode) && !string.IsNullOrEmpty(pm.TypeOfMovementIen)))
                                    {
                                        cdTom = null;
                                        if (string.IsNullOrEmpty(movement.TypeOfMovementCode))
                                        {
                                            if (!string.IsNullOrEmpty(pm.TypeOfMovementIen))
                                                cdTom = typeOfMovements.Where(a => a.code.Equals(VistaSite.Name + "_" + pm.TypeOfMovementIen, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                                        }
                                        else if (!string.IsNullOrEmpty(pm.TypeOfMovementIen) && movement.TypeOfMovementCode.Substring(movement.TypeOfMovementCode.IndexOf("_") + 1) != pm.TypeOfMovementIen)
                                            cdTom = typeOfMovements.Where(a => a.code.Equals(VistaSite.Name + "_" + pm.TypeOfMovementIen, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                                        // movement was updated
                                        if (movement.TransactionTypeId == "1")
                                        {
                                            admEvent = BMSFactory.BedManagerOperationsClientWindows.GetAdmissionEvent(new II(domain, movement.Id.ToString()));
                                            admEvent.AdmissionDate = movementDateUtc;
                                            admEvent.EnteredDate = enteredDateUtc;
                                            if (string.IsNullOrEmpty(pm.TypeOfMovementIen))
                                                admEvent.MovementType = null;
                                            else if (cdTom != null)
                                                admEvent.MovementType = cdTom;
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateAdmissionEvent(admEvent);
                                            admEvent = null;
                                        }
                                        else if (movement.TransactionTypeId == "2")
                                        {
                                            movEvent = BMSFactory.BedManagerOperationsClientWindows.GetMovementEvent(new II(domain, movement.Id.ToString()));
                                            movEvent.MovementDate = movementDateUtc;
                                            movEvent.EnteredDate = enteredDateUtc;
                                            if (string.IsNullOrEmpty(pm.TypeOfMovementIen))
                                                movEvent.MovementType = null;
                                            else if (cdTom != null)
                                                movEvent.MovementType = cdTom;
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateMovementEvent(movEvent);
                                            movEvent = null;
                                        }
                                        else if (movement.TransactionTypeId == "3")
                                        {
                                            disEvent = BMSFactory.BedManagerOperationsClientWindows.GetDischargeEvent(new II(domain, movement.Id.ToString()));
                                            disEvent.DischargedDate = movementDateUtc;
                                            disEvent.EnteredDate = enteredDateUtc;
                                            if (string.IsNullOrEmpty(pm.TypeOfMovementIen))
                                                disEvent.MovementType = null;
                                            else if (cdTom != null)
                                                disEvent.MovementType = cdTom;
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateDischargeEvent(disEvent);
                                            disEvent = null;
                                        }
                                        else if (movement.TransactionTypeId == "6")
                                        {
                                            spEvent = BMSFactory.BedManagerOperationsClientWindows.GetSpecialtyTransfer(new II(domain, movement.Id.ToString()));
                                            spEvent.DateTime = movementDateUtc;
                                            spEvent.EnteredDate = enteredDateUtc;
                                            if (string.IsNullOrEmpty(pm.TypeOfMovementIen))
                                                spEvent.TypeOfMovement = null;
                                            else if (cdTom != null)
                                                spEvent.TypeOfMovement = cdTom;
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateSpecialtyTransfer(spEvent);
                                            spEvent = null;
                                        }
                                    }
                                }
                            }
                        }
                        typeOfMovements = null;
                        movement = null;
                        patient = null;
                        patientIen = null;
                        cdTom = null;
                        
                        #endregion

                        #region Process selected movements for delete
                        
                        if (forDelete.Count > 0)
                        {
                            PatientMovement pm = null;                            
                            MovementIen bmsMovement = null;

                            StringBuilder sb = new StringBuilder();
                            int count = 0;                            
                            foreach (string ien in forDelete)
                            {
                                if (!forDeleteWithNoCheck.Contains(ien))
                                    pm = Query.GetPatientMovementByIen(ien);
                                else
                                    pm = null;
                                if (pm != null)
                                {
                                    try
                                    {
                                        bmsMovement = bmsMovementsDictionary[ien];
                                    }
                                    catch { bmsMovement = null; }
                                    if (bmsMovement != null)
                                    {
                                        if (bmsMovement.TransactionTypeId == "1")
                                        {
                                            admEvent = BMSFactory.BedManagerOperationsClientWindows.GetAdmissionEvent(new II(domain, bmsMovement.Id.ToString()));
                                            admEvent.EnteredDate = pm.EnteredOnDateTime.HasValue ? VistaSite.ConvertToUtcDateTime(pm.EnteredOnDateTime.Value) : DateTime.UtcNow;
                                            admEvent.AdmissionDate = VistaSite.ConvertToUtcDateTime(pm.DateTime);
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateAdmissionEvent(admEvent);
                                            admEvent = null;
                                        }
                                        else if (bmsMovement.TransactionTypeId == "2")
                                        {
                                            movEvent = BMSFactory.BedManagerOperationsClientWindows.GetMovementEvent(new II(domain, bmsMovement.Id.ToString()));
                                            movEvent.EnteredDate = pm.EnteredOnDateTime.HasValue ? VistaSite.ConvertToUtcDateTime(pm.EnteredOnDateTime.Value) : DateTime.UtcNow;
                                            movEvent.MovementDate = VistaSite.ConvertToUtcDateTime(pm.DateTime);
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateMovementEvent(movEvent);
                                            movEvent = null;
                                        }
                                        else if (bmsMovement.TransactionTypeId == "3")
                                        {
                                            disEvent = BMSFactory.BedManagerOperationsClientWindows.GetDischargeEvent(new II(domain, bmsMovement.Id.ToString()));
                                            disEvent.EnteredDate = pm.EnteredOnDateTime.HasValue ? VistaSite.ConvertToUtcDateTime(pm.EnteredOnDateTime.Value) : DateTime.UtcNow;
                                            disEvent.DischargedDate = VistaSite.ConvertToUtcDateTime(pm.DateTime);
                                            BMSFactory.BedManagerOperationsClientWindows.UpdateDischargeEvent(disEvent);
                                            disEvent = null;
                                        }
                                    }
                                }
                                else
                                {
                                    sb.Append(ien);
                                    sb.Append(",");
                                    count = count + 1;
                                    if (count == 10)
                                    {                                      
                                        BMSFactory.BedManagerOperationsClientWindows.ManageDeletedMovements(sb.ToString(), vistASiteId, VistaSite.Name);
                                        count = 0;
                                        sb.Clear();
                                    }
                                }
                            }
                            if (count > 0)
                                BMSFactory.BedManagerOperationsClientWindows.ManageDeletedMovements(sb.ToString(), vistASiteId, VistaSite.Name);
                            sb = null;
                            pm = null;
                            bmsMovement = null;
                        }                        
                        bmsMovementsDictionary = null;

                        #endregion

                        #region Process selected movements for insert
                        
                        if (forInsert.Count > 0)
                        {
                            Dictionary<string, PatientMovementIen> movementsForInsert = new Dictionary<string, PatientMovementIen>();
                            foreach (string ien in forInsert)
                                movementsForInsert.Add(ien, vistaMovementsDictionary[ien]);

                            var s1 = GetEntitiesProcessor<PatientMovement>(() => GetMovementsForIens(movementsForInsert), null, null);
                            movementsForInsert = null;
                            //get admission iens for movements
                            decimal transaction = 0;                            
                            List<string> admissionIens = new List<string>();
                            foreach (PatientMovement pm in s1.Entries)
                            {
                                decimal.TryParse(pm.TransactionTypeId, out transaction);                                
                                if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX)
                                    || (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX)
                                    || (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX))                                
                                    admissionIens.Add(pm.CurrentAdmissionIen);                               
                            }

                            StringBuilder sb = new StringBuilder();
                            int count = 0;
                            List<string> missingAdmissions = new List<string>();
                            foreach (string ien in admissionIens)
                            {
                                if (s1.Entries.Where(a => a.IEN == ien).FirstOrDefault() == null)
                                {
                                    sb.Append(ien);
                                    sb.Append(",");
                                    count = count + 1;
                                }
                                if (count == 50)
                                {
                                    missingAdmissions.AddRange(BMSFactory.BedManagerQueryClientWindows.GetMissingAdmissions(sb.ToString(), vistASiteId));
                                    count = 0;
                                    sb.Clear();
                                }
                            }
                            if (count > 0)
                                missingAdmissions.AddRange(BMSFactory.BedManagerQueryClientWindows.GetMissingAdmissions(sb.ToString(), vistASiteId));
                            admissionIens = null;
                            sb = null;
                            if (missingAdmissions != null && missingAdmissions.Count > 0)
                            {
                                PatientMovement obj = null;
                                transaction = 0;
                                foreach (string ien in missingAdmissions)
                                {
                                    if (!string.IsNullOrEmpty(ien))
                                    {
                                        obj = Query.GetPatientMovementByIen(ien);                                        
                                        if (obj == null)
                                            continue;
                                        decimal.TryParse(obj.TransactionTypeId, out transaction);
                                        if (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX)
                                        {
                                            if (string.IsNullOrEmpty(obj.WardLocationId) && string.IsNullOrEmpty(obj.RoomBedId))
                                                continue;
                                        }
                                        s1.Entries.Add(obj);
                                    }
                                }
                                obj = null;
                            }
                            missingAdmissions = null;
                            s1.RetrievedEntries = s1.Entries.Count;
                            if (s1.Entries != null && s1.Entries.Count > 0)
                                s1.Entries = (from a in (s1.Entries as List<PatientMovement>) orderby a.EnteredOnDateTime select a).ToList();
                            s1.Entries.ForEach(i => logs.Add(new VistaIntegrationLog() { File = VistaFiles.PatientMovement, Ien = i.IEN }));
                            result.Add(s1);
                            LogChecker = new HashSetLogChecker(logs, VistaSite.Name);
                            result.ForEach(s => s.InitLogCheck(LogChecker));
                        } 
                       
                        #endregion
                                             
                        forInsert = null;
                        forDelete = null;
                        forDeleteWithNoCheck = null;                        
                    }

                    #region Process movement without bed
                    
                    if (bmsMovementsWithoutBed != null && bmsMovementsWithoutBed.Count > 0)
                    {
                        PatientMovementIen pmi = null;
                        StringBuilder sb = new StringBuilder();
                        List<FC.Ward> wards = EISFactory.InstanceWindows.GetWardsByVistaSiteId(vistASiteId).ToList();
                        List<FC.Bed> beds = EISFactory.InstanceWindows.GetBedsByVista(vistASiteId);
                        
                        int count = 0;
                        FC.Ward ward = null;
                        FC.Bed bed = null;
                        foreach (MovementWithoutBed mwb in bmsMovementsWithoutBed)
                        {
                            try
                            {
                                pmi = vistaMovementsDictionary[mwb.MovementIen];
                            }
                            catch { pmi = null; }
                            if (pmi != null && !string.IsNullOrEmpty(pmi.WardLocationId) && !string.IsNullOrEmpty(pmi.RoomBedId))
                            {
                                ward = wards.Where(a => a.Ien.Equals(pmi.WardLocationId)).FirstOrDefault();
                                bed = beds.Where(a => a.Ien.Equals(pmi.RoomBedId)).FirstOrDefault();
                                if (ward != null)
                                {
                                    if (bed != null)
                                    {
                                        sb.Append(pmi.IEN);
                                        sb.Append(",");
                                        sb.Append(ward.Id.extension);
                                        sb.Append(",");
                                        sb.Append(bed.Id.extension);
                                        sb.Append(",");
                                        count = count + 1;
                                    }
                                    else
                                    {
                                        PatientMovement pm = Query.GetPatientMovementByIen(pmi.IEN);
                                        if (pm != null && pm.Bed != null)
                                        {
                                            bed = new FC.Bed();
                                            bed.WardList = new List<FC.Ward>();
                                            bed.Ien = pm.Bed.IEN;
                                            bed.Name = pm.Bed.Name;
                                            bed.IsBedHold = !(string.IsNullOrEmpty(pm.Bed.BedHoldPatientIen)) && pm.Bed.BedHoldPatientIen != "0";
                                            bed.VistaSite = new FC.VistaSite() { Id = vistASiteId };
                                            EIS_EVSLockWrapper.InsertBed(bed, VistaSite.Name);

                                            if (bed.Id != null)
                                            {
                                                sb.Append(pmi.IEN);
                                                sb.Append(",");
                                                sb.Append(ward.Id.extension);
                                                sb.Append(",");
                                                sb.Append(bed.Id.extension);
                                                sb.Append(",");
                                                count = count + 1;
                                            }
                                        }
                                    }
                                }
                            }
                            if (count == 20)
                            {
                                BMSFactory.BedManagerOperationsClientWindows.UpdateMovementsWithoutBed(sb.ToString(), vistASiteId);                            
                                sb.Clear();
                                count = 0;
                            }
                        }
                        if (count > 0)
                            BMSFactory.BedManagerOperationsClientWindows.UpdateMovementsWithoutBed(sb.ToString(), vistASiteId);
                        wards = null;
                        beds = null;
                        pmi = null;
                        sb = null;
                        ward = null;
                        bed = null;
                        bmsMovementsWithoutBed = null;
                    }
                    
                    #endregion
                    vistaMovementsDictionary = null;
                }                
            }
            return result;
        }

        private List<PatientMovement> GetMovementsForIens(Dictionary<string, PatientMovementIen> movements)
        {
            List<PatientMovement> result = new List<PatientMovement>();
            PatientMovement pm = null;
            decimal transaction = 0;
            foreach (string ien in movements.Keys)
            {
                decimal.TryParse(movements[ien].TransactionTypeId, out transaction);
                if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX)
                    || (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX))
                {
                    if (string.IsNullOrEmpty(movements[ien].WardLocationId) && string.IsNullOrEmpty(movements[ien].RoomBedId))
                        continue;
                }
                pm = Query.GetPatientMovementByIen(ien);
                if (pm == null)
                    continue;                
                result.Add(pm);
            }
            return result;
        }
    }
}
