﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.Maps.SingleMaps;

namespace Mdws2ORM.Maps.EIS
{
    public class RoomBedMap : EntityMap<RoomBed>
    {
        public override RoomBed NewEntity(string ien)
        {
            return new RoomBed() { IEN = ien, };
        }

        public override string File
        {
            get { return "405.4"; }
        }

        public override string Location
        {
            get { return "DG(405.4,"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
            MapBoolean(".2", (m, s) => m.CurrentlyOutOfService = s);
            MapFreeText("100", (m, s) => m.WardsWhichCanAssignString = s);
        }
    }
}
