﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws.Commands;
using Mdws2ORM.Maps;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.SubEntityCommands
{
    public static class SubEntityCommandStrategy
    {

        public static List<T> Execute<T, V>(ISession session, ListParam listParam, ListParam subListParam, BaseListCommand<T> command, out Entry LastEntry)
            where T : class
            where V : class
        {
            Entry currentEntry = new Entry();
            var enumerable = session.ListAllSubEntities<T, V>(listParam, subListParam, command.GetIens())
                .Select(s =>
                    {
                        currentEntry = s.Entry;
                        return s.Entity;
                    });

            Func<T, bool> predicate = command.GetPredicate();
            if (predicate != null) enumerable = enumerable.Where(predicate);
            List<T> result = enumerable.ToList();
            LastEntry = currentEntry;
            return result;
        }

    }
}
